/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.Predicate;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.CriterionPredicateRegistry;
import net.shibboleth.utilities.java.support.resolver.FooPredicate;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.resolver.TestCriterion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CriterionPredicateRegistryTest {
    private TestCriterion fooCriterion;
    private Class<TestCriterion> testCriterionClass = TestCriterion.class;
    private Class<FooPredicate> fooPredicateClass = FooPredicate.class;

    @BeforeMethod
    public void setUp() {
        this.fooCriterion = new TestCriterion();
    }

    @Test
    public void testExplictRegisterDeregister() throws ResolverException {
        CriterionPredicateRegistry registry = new CriterionPredicateRegistry();
        Assert.assertNull((Object)registry.getPredicate((Criterion)this.fooCriterion));
        registry.register(this.testCriterionClass, this.fooPredicateClass);
        Predicate predicate = registry.getPredicate((Criterion)this.fooCriterion);
        Assert.assertNotNull((Object)predicate);
        Assert.assertTrue((boolean)this.fooPredicateClass.isInstance(predicate));
        registry.deregister(this.testCriterionClass);
        Assert.assertNull((Object)registry.getPredicate((Criterion)this.fooCriterion));
        registry.register(this.testCriterionClass, this.fooPredicateClass);
        predicate = registry.getPredicate((Criterion)this.fooCriterion);
        Assert.assertNotNull((Object)predicate);
        registry.clearRegistry();
        predicate = registry.getPredicate((Criterion)this.fooCriterion);
        Assert.assertNull((Object)predicate);
    }

    @Test
    public void testRelativeClassPathResourceLoad() throws ResolverException {
        CriterionPredicateRegistry registry = new CriterionPredicateRegistry();
        Assert.assertNull((Object)registry.getPredicate((Criterion)this.fooCriterion));
        registry.loadMappings("test-criterion-predicate-mappings.properties");
        Predicate predicate = registry.getPredicate((Criterion)this.fooCriterion);
        Assert.assertNotNull((Object)predicate);
        Assert.assertTrue((boolean)this.fooPredicateClass.isInstance(predicate));
    }

    @Test
    public void testAbsoluteClassPathResourceLoad() throws ResolverException {
        CriterionPredicateRegistry registry = new CriterionPredicateRegistry();
        Assert.assertNull((Object)registry.getPredicate((Criterion)this.fooCriterion));
        registry.loadMappings("/net/shibboleth/utilities/java/support/resolver/test-criterion-predicate-mappings.properties");
        Predicate predicate = registry.getPredicate((Criterion)this.fooCriterion);
        Assert.assertNotNull((Object)predicate);
        Assert.assertTrue((boolean)this.fooPredicateClass.isInstance(predicate));
    }

    @Test
    public void testPropertiesLoad() throws ResolverException, IOException {
        CriterionPredicateRegistry registry = new CriterionPredicateRegistry();
        Assert.assertNull((Object)registry.getPredicate((Criterion)this.fooCriterion));
        Properties properties = new Properties();
        try (InputStream is = this.getClass().getResourceAsStream("test-criterion-predicate-mappings.properties");){
            properties.load(is);
        }
        registry.loadMappings(properties);
        Predicate predicate = registry.getPredicate((Criterion)this.fooCriterion);
        Assert.assertNotNull((Object)predicate);
        Assert.assertTrue((boolean)this.fooPredicateClass.isInstance(predicate));
    }
}

