/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.primitive;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StringSupportTest {
    @Nonnull
    @NotEmpty
    private static final String TRIM_TEST1 = " AARDVARK incorporated";
    @Nonnull
    @NotEmpty
    private static final String EMPTY_TRIM_TEST2 = " \t ";
    @Nonnull
    @NotEmpty
    private static final String SEPARATOR = "+";
    @Nonnull
    @NotEmpty
    private static final String TEST_LIST = "1+x2+y3+z4+5+6+";
    @Nonnull
    private static final List<String> TEST_LIST_AS_LIST = Arrays.asList("1", "x2", "y3", "z4", "5", "6", "");

    @Test
    public void testInputStreamToString() throws IOException {
        String str = null;
        ClassPathResource resource = new ClassPathResource("/net/shibboleth/utilities/java/support/primitive/data.txt");
        try (InputStream stream = resource.getInputStream();){
            str = StringSupport.inputStreamToString((InputStream)stream, null);
        }
        Assert.assertNotNull((Object)str);
        Assert.assertEquals((String)str, (String)"The quick, brown lizard jumped over the lazy fish.\nWait, I mean the slow, blue elephant jumped over the motivated squirrel.\nNo, that's wrong too.\n");
    }

    @Test
    public void testListToStringValue() {
        Assert.assertEquals((String)StringSupport.listToStringValue(TEST_LIST_AS_LIST, (String)SEPARATOR), (String)TEST_LIST, (String)"toList<String> fails");
        boolean thrown = false;
        try {
            StringSupport.listToStringValue(TEST_LIST_AS_LIST, (String)((String)this.nullValue()));
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null separator should throw an assertion");
        thrown = false;
        try {
            StringSupport.listToStringValue((List)((List)this.nullValue()), (String)SEPARATOR);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null list should throw an assertion");
    }

    @Test
    public void testStringToList() {
        Assert.assertEquals((Collection)StringSupport.stringToList((String)TEST_LIST, (String)SEPARATOR), TEST_LIST_AS_LIST, (String)"from List<String> fails");
        Assert.assertTrue((boolean)StringSupport.stringToList((String)"", (String)SEPARATOR).isEmpty(), (String)"Empty input should give empty list");
        boolean thrown = false;
        try {
            StringSupport.stringToList((String)((String)this.nullValue()), (String)SEPARATOR);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Null input should throw an assertion");
        thrown = false;
        try {
            StringSupport.stringToList((String)TEST_LIST, (String)((String)this.nullValue()));
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Null separator should throw an assertion");
    }

    @Test
    public void testTrim() {
        Assert.assertEquals((String)StringSupport.trim(null), null, (String)"Trimming Null should be OK");
        Assert.assertEquals((int)StringSupport.trim((String)EMPTY_TRIM_TEST2).length(), (int)0, (String)"Trimming an empty string should return a string of zero length");
        Assert.assertEquals((String)StringSupport.trim((String)TRIM_TEST1), (String)TRIM_TEST1.trim(), (String)"Trimming a string");
    }

    @Test
    public void testTrimOrNull() {
        Assert.assertEquals((String)StringSupport.trimOrNull(null), null, (String)"Trimming Null should be OK");
        Assert.assertEquals((String)StringSupport.trimOrNull((String)EMPTY_TRIM_TEST2), null, (String)"Trimming an empty string should return null");
        Assert.assertEquals((String)StringSupport.trim((String)TRIM_TEST1), (String)TRIM_TEST1.trim(), (String)"Trimming a string");
    }

    @Test
    public void testNormalizeStringCollection() {
        Collection output = StringSupport.normalizeStringCollection(new HashSet<String>(Arrays.asList("foo", "bar", "baz")));
        Assert.assertEquals((int)output.size(), (int)3);
        Assert.assertTrue((boolean)output.contains("foo"));
        Assert.assertTrue((boolean)output.contains("bar"));
        Assert.assertTrue((boolean)output.contains("baz"));
        output = StringSupport.normalizeStringCollection(new HashSet<String>(Arrays.asList(" \t\t foo  ", "  ", "  baz \r\n")));
        Assert.assertEquals((int)output.size(), (int)2);
        Assert.assertTrue((boolean)output.contains("foo"));
        Assert.assertTrue((boolean)output.contains("baz"));
        output = StringSupport.normalizeStringCollection(new HashSet<String>(Arrays.asList("   foo   ", null, "baz")));
        Assert.assertEquals((int)output.size(), (int)2);
        Assert.assertTrue((boolean)output.contains("foo"));
        Assert.assertTrue((boolean)output.contains("baz"));
        output = StringSupport.normalizeStringCollection(new HashSet());
        Assert.assertEquals((int)output.size(), (int)0);
        output = StringSupport.normalizeStringCollection(null);
        Assert.assertEquals((int)output.size(), (int)0);
    }

    private <T> T nullValue() {
        return null;
    }

    @Test
    public void testToBoolean() {
        Assert.assertNull((Object)StringSupport.booleanOf((String)""));
        Assert.assertFalse((boolean)Boolean.valueOf(""));
        Assert.assertNull((Object)StringSupport.booleanOf(null));
        Assert.assertFalse((boolean)Boolean.valueOf(null));
        Assert.assertTrue((boolean)StringSupport.booleanOf((String)"true"));
        Assert.assertTrue((boolean)Boolean.valueOf("true"));
        Assert.assertFalse((boolean)StringSupport.booleanOf((String)"false"));
        Assert.assertFalse((boolean)Boolean.valueOf("false"));
        Assert.assertFalse((boolean)StringSupport.booleanOf((String)"0"));
        Assert.assertTrue((boolean)StringSupport.booleanOf((String)"1"));
        try {
            StringSupport.booleanOf((String)"elephant");
            Assert.fail((String)"Should have thrown");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }
}

