/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ListTest {
    private static final String[] TEST_ARRAY = new String[]{"Zero", "One", "Two", "Three"};
    private static final String TEST_VALUE = "tWO";

    @Test
    public void verifyTests() {
        ListTest.testListFunctions(new ArrayList<String>());
        ListTest.testListIterator(new ArrayList<String>());
    }

    public static void testListFunctions(List<String> list) {
        int i;
        int i2;
        boolean thrown = false;
        try {
            list.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Should throw exception when lookup up after the end");
        thrown = false;
        try {
            list.get(1);
        }
        catch (IndexOutOfBoundsException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Should throw exception when lookup up after the end");
        list.add(TEST_ARRAY[0]);
        Assert.assertEquals((String)list.get(0), (String)TEST_ARRAY[0], (String)"Single insert");
        thrown = false;
        try {
            list.get(1);
        }
        catch (IndexOutOfBoundsException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Should throw exception when lookup up after the end");
        for (i2 = 1; i2 < TEST_ARRAY.length; ++i2) {
            list.add(TEST_ARRAY[i2]);
        }
        for (i2 = 0; i2 < TEST_ARRAY.length; ++i2) {
            Assert.assertEquals((String)list.get(i2), (String)TEST_ARRAY[i2], (String)("Contents not as expected at " + i2));
        }
        Assert.assertEquals((String)list.set(2, TEST_VALUE), (String)TEST_ARRAY[2], (String)"Replaced contents not as expected");
        Assert.assertEquals((String)list.get(2), (String)TEST_VALUE, (String)"Contents not as expected after replace");
        for (i2 = 0; i2 < TEST_ARRAY.length; ++i2) {
            if (i2 == 2) continue;
            Assert.assertEquals((String)list.get(i2), (String)TEST_ARRAY[i2], (String)("Contents not as expected at " + i2));
        }
        Assert.assertEquals((int)list.size(), (int)TEST_ARRAY.length, (String)"Size matches after in place replace");
        Assert.assertEquals((String)list.set(2, TEST_ARRAY[2]), (String)TEST_VALUE, (String)"Replaced contents not as expected");
        list.add(2, TEST_VALUE);
        Assert.assertEquals((int)list.size(), (int)(TEST_ARRAY.length + 1), (String)"Size matches after insert");
        for (i2 = 0; i2 < 2; ++i2) {
            Assert.assertEquals((String)list.get(i2), (String)TEST_ARRAY[i2], (String)("Contents not as expected at " + i2));
        }
        Assert.assertEquals((String)list.get(2), (String)TEST_VALUE, (String)"Contents not as expected after insert");
        for (i2 = 2; i2 < TEST_ARRAY.length; ++i2) {
            Assert.assertEquals((String)list.get(i2 + 1), (String)TEST_ARRAY[i2], (String)("Contents not as expected at " + i2));
        }
        thrown = false;
        try {
            list.set(5, TEST_VALUE);
        }
        catch (IndexOutOfBoundsException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Should throw exception when inserting after the end");
        list.add(TEST_ARRAY.length, TEST_VALUE);
        Assert.assertEquals((String)list.get(TEST_ARRAY.length), (String)TEST_VALUE, (String)"Contents not as expected after insert");
        list.clear();
        thrown = false;
        try {
            list.set(0, TEST_VALUE);
        }
        catch (IndexOutOfBoundsException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Should throw exception when inserting after the end");
        thrown = false;
        try {
            list.add(1, TEST_VALUE);
        }
        catch (IndexOutOfBoundsException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Should throw exception when inserting after the end");
        Assert.assertTrue((list.size() == 0 ? 1 : 0) != 0, (String)"Still empty after all those attempted adds");
        list.add(0, TEST_VALUE);
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0, (String)"But one element");
        thrown = false;
        try {
            list.set(1, TEST_VALUE);
        }
        catch (IndexOutOfBoundsException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Should throw exception when inserting after the end");
        thrown = false;
        try {
            list.add(2, TEST_VALUE);
        }
        catch (IndexOutOfBoundsException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Should throw exception when inserting after the end");
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0, (String)"Still only one element");
        list.add(1, TEST_VALUE);
        Assert.assertTrue((list.size() == 2 ? 1 : 0) != 0, (String)"Two elements");
        list.clear();
        Assert.assertEquals((int)list.indexOf(TEST_VALUE), (int)-1, (String)"Should not find an element");
        Assert.assertEquals((int)list.lastIndexOf(TEST_VALUE), (int)-1, (String)"Should not find an element");
        list.add(TEST_ARRAY[0]);
        Assert.assertEquals((int)list.indexOf(TEST_VALUE), (int)-1, (String)"Should not find this element");
        Assert.assertEquals((int)list.lastIndexOf(TEST_VALUE), (int)-1, (String)"Should not find this element");
        Assert.assertEquals((int)list.indexOf(TEST_ARRAY[0]), (int)0, (String)"Should find this element");
        Assert.assertEquals((int)list.lastIndexOf(TEST_ARRAY[0]), (int)0, (String)"Should find this element");
        for (i = 1; i < TEST_ARRAY.length; ++i) {
            list.add(TEST_ARRAY[i]);
        }
        for (i = 0; i < TEST_ARRAY.length; ++i) {
            list.add(TEST_ARRAY[i]);
        }
        for (i = 0; i < TEST_ARRAY.length; ++i) {
            list.add(TEST_ARRAY[i]);
        }
        Assert.assertEquals((int)list.indexOf(TEST_VALUE), (int)-1, (String)"Should not find this element");
        Assert.assertEquals((int)list.lastIndexOf(TEST_VALUE), (int)-1, (String)"Should not find this element");
        for (i = 0; i < TEST_ARRAY.length; ++i) {
            Assert.assertEquals((int)list.indexOf(TEST_ARRAY[i]), (int)i, (String)"Should find this element");
            Assert.assertEquals((int)list.lastIndexOf(TEST_ARRAY[i]), (int)(i + 2 * TEST_ARRAY.length), (String)"Should find this element");
        }
    }

    public static void testListIterator(List<String> list) {
        int i;
        list.clear();
        for (i = 0; i < TEST_ARRAY.length; ++i) {
            list.add(TEST_ARRAY[i]);
        }
        ListIterator<String> listIterator = list.listIterator();
        listIterator.next();
        listIterator.add(TEST_VALUE);
        Assert.assertEquals((String)list.get(0), (String)TEST_ARRAY[0], (String)"Iterator insert");
        Assert.assertEquals((String)list.get(1), (String)TEST_VALUE, (String)"Iterator insert");
        for (i = 1; i < TEST_ARRAY.length; ++i) {
            Assert.assertEquals((String)list.get(i + 1), (String)TEST_ARRAY[i], (String)"Iterator insert");
        }
        list.clear();
        for (i = 0; i < TEST_ARRAY.length; ++i) {
            list.add(TEST_ARRAY[i]);
        }
        listIterator = list.listIterator(1);
        listIterator.add(TEST_VALUE);
        Assert.assertEquals((String)list.get(0), (String)TEST_ARRAY[0], (String)"Iterator insert");
        Assert.assertEquals((String)list.get(1), (String)TEST_VALUE, (String)"Iterator insert");
        for (i = 1; i < TEST_ARRAY.length; ++i) {
            Assert.assertEquals((String)list.get(i + 1), (String)TEST_ARRAY[i], (String)"Iterator insert");
        }
        for (i = 0; i < list.size(); ++i) {
            list.set(i, TEST_VALUE);
        }
        listIterator = list.listIterator();
        i = 0;
        while (listIterator.hasNext()) {
            Assert.assertEquals((String)listIterator.next(), (String)TEST_VALUE, (String)"Iterator next");
            if (i >= TEST_ARRAY.length) continue;
            listIterator.set(TEST_ARRAY[i++]);
        }
        for (i = 1; i < TEST_ARRAY.length; ++i) {
            Assert.assertEquals((String)list.get(i), (String)TEST_ARRAY[i], (String)"Iterator set");
        }
        Assert.assertEquals((String)list.get(list.size() - 1), (String)TEST_VALUE, (String)"Iterator set");
        i = 0;
        while (listIterator.hasPrevious()) {
            listIterator.previous();
            listIterator.set(TEST_VALUE);
        }
        for (i = 0; i < list.size(); ++i) {
            Assert.assertEquals((String)list.get(i), (String)TEST_VALUE, (String)"Iterator set");
        }
    }
}

