/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.collection;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.shibboleth.utilities.java.support.collection.ClassIndexedSet;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ClassIndexedSetTest {
    private ClassIndexedSet<Member> memberSet;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.memberSet = new ClassIndexedSet();
    }

    @Test
    public void testDupInstance() {
        A memberA = new A("owner");
        this.memberSet.add((Object)memberA);
        try {
            this.memberSet.add((Object)memberA);
            Assert.fail((String)"Set already contained the specified instance");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDupType() {
        A memberA1 = new A("owner");
        A memberA2 = new A("owner#2");
        this.memberSet.add((Object)memberA1);
        try {
            this.memberSet.add((Object)memberA2);
            Assert.fail((String)"Set already contained an instance of the specified class");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDupTypeWithReplacement() {
        A memberA1 = new A("owner");
        A memberA2 = new A("owner#2");
        this.memberSet.add((Object)memberA1);
        try {
            this.memberSet.add((Object)memberA2, true);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Set should have replaced existing member type");
        }
        Assert.assertFalse((memberA1 == this.memberSet.get(A.class) ? 1 : 0) != 0, (String)"Did not find the expected member instance");
        Assert.assertTrue((memberA2 == this.memberSet.get(A.class) ? 1 : 0) != 0, (String)"Did not find the expected member instance");
    }

    @Test
    public void testGetType() {
        A memberA = new A("owner");
        this.memberSet.add((Object)memberA);
        B memberB = new B("algorithm");
        this.memberSet.add((Object)memberB);
        Assert.assertTrue((memberA == this.memberSet.get(A.class) ? 1 : 0) != 0, (String)"Did not find the expected member instance");
        Assert.assertTrue((memberB == this.memberSet.get(B.class) ? 1 : 0) != 0, (String)"Did not find the expected member instance");
        Assert.assertTrue((null == this.memberSet.get(C.class) ? 1 : 0) != 0, (String)"Did not find the expected (null) member instance");
    }

    @Test
    public void testRemove() {
        A memberA = new A("owner");
        this.memberSet.add((Object)memberA);
        B memberB = new B("algorithm");
        this.memberSet.add((Object)memberB);
        Assert.assertEquals((int)this.memberSet.size(), (int)2, (String)"Set had unexpected size");
        Assert.assertTrue((boolean)this.memberSet.contains(A.class));
        Assert.assertTrue((boolean)this.memberSet.contains(B.class));
        this.memberSet.remove((Object)memberB);
        Assert.assertEquals((int)this.memberSet.size(), (int)1, (String)"Set had unexpected size");
        Assert.assertTrue((boolean)this.memberSet.contains(A.class));
        Assert.assertNull((Object)this.memberSet.get(B.class), (String)"Set returned removed value");
        this.memberSet.remove(null);
        Assert.assertEquals((int)this.memberSet.size(), (int)1, (String)"Set had unexpected size");
        Assert.assertTrue((boolean)this.memberSet.contains(A.class));
        Assert.assertNull((Object)this.memberSet.get(B.class), (String)"Set returned removed value");
        this.memberSet.remove((Object)new C("foo"));
        Assert.assertEquals((int)this.memberSet.size(), (int)1, (String)"Set had unexpected size");
        Assert.assertTrue((boolean)this.memberSet.contains(A.class));
        Assert.assertNull((Object)this.memberSet.get(B.class), (String)"Set returned removed value");
        this.memberSet.remove((Object)memberA);
        Assert.assertEquals((int)this.memberSet.size(), (int)0, (String)"Set had unexpected size");
        Assert.assertNull((Object)this.memberSet.get(A.class), (String)"Set returned removed value");
        Assert.assertNull((Object)this.memberSet.get(B.class), (String)"Set returned removed value");
    }

    @Test
    public void testClear() {
        A memberA = new A("owner");
        this.memberSet.add((Object)memberA);
        B memberB = new B("algorithm");
        this.memberSet.add((Object)memberB);
        Assert.assertEquals((int)this.memberSet.size(), (int)2, (String)"Set had unexpected size");
        this.memberSet.clear();
        Assert.assertEquals((int)this.memberSet.size(), (int)0, (String)"Set had unexpected size");
        Assert.assertNull((Object)this.memberSet.get(B.class), (String)"Set returned removed value");
        Assert.assertNull((Object)this.memberSet.get(A.class), (String)"Set returned removed value");
    }

    @Test
    public void testIterator() {
        A memberA = new A("owner");
        this.memberSet.add((Object)memberA);
        B memberB = new B("algorithm");
        this.memberSet.add((Object)memberB);
        C memberC = new C(null);
        this.memberSet.add((Object)memberC);
        Assert.assertEquals((int)this.memberSet.size(), (int)3, (String)"Set had unexpected size");
        int count = 0;
        HashSet<Member> unique = new HashSet<Member>();
        for (Member member : this.memberSet) {
            ++count;
            Assert.assertTrue((boolean)unique.add(member), (String)"Duplicate was returned by iterator");
        }
        Assert.assertEquals((int)count, (int)3, (String)"Set iteration had unexpected count");
        Iterator iterator = this.memberSet.iterator();
        Assert.assertTrue((boolean)iterator.hasNext(), (String)"Iterator should have more elements");
        iterator.next();
        Assert.assertTrue((boolean)iterator.hasNext(), (String)"Iterator should have more elements");
        iterator.next();
        Assert.assertTrue((boolean)iterator.hasNext(), (String)"Iterator should have more elements");
        iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext(), (String)"Iterator should have no more elements");
        try {
            iterator.next();
            Assert.fail((String)"Should have seen a iterator exception, no more elements available in set");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testIteratorRemove() {
        this.memberSet = new ClassIndexedSet();
        A memberA = new A("owner");
        this.memberSet.add((Object)memberA);
        B memberB = new B("algorithm");
        this.memberSet.add((Object)memberB);
        C memberC = new C(null);
        this.memberSet.add((Object)memberC);
        D memberD = new D("128");
        this.memberSet.add((Object)memberD);
        Assert.assertEquals((int)this.memberSet.size(), (int)4, (String)"Set had unexpected size");
        Iterator iterator = this.memberSet.iterator();
        Member member = null;
        while (iterator.hasNext()) {
            member = (Member)iterator.next();
            if (!(member instanceof B)) continue;
            iterator.remove();
        }
        Assert.assertEquals((int)this.memberSet.size(), (int)3, (String)"Set iteration had unexpected size");
        Assert.assertTrue((boolean)this.memberSet.contains((Object)memberA), (String)"Set did not contain expected instance");
        Assert.assertTrue((boolean)this.memberSet.contains((Object)memberC), (String)"Set did not contain expected instance");
        Assert.assertTrue((boolean)this.memberSet.contains((Object)memberD), (String)"Set did not contain expected instance");
        Assert.assertFalse((boolean)this.memberSet.contains((Object)memberB), (String)"Set contained unexpected instance");
        Assert.assertTrue((boolean)this.memberSet.contains(A.class), (String)"Set did not contain expected class type");
        Assert.assertTrue((boolean)this.memberSet.contains(C.class), (String)"Set did not contain expected class type");
        Assert.assertTrue((boolean)this.memberSet.contains(D.class), (String)"Set did not contain expected class type");
        Assert.assertFalse((boolean)this.memberSet.contains(B.class), (String)"Set contained unexpected class type");
    }

    @Test
    public void testIteratorRemoveIllegal() {
        this.memberSet = new ClassIndexedSet();
        A memberA = new A("owner");
        this.memberSet.add((Object)memberA);
        B memberB = new B("algorithm");
        this.memberSet.add((Object)memberB);
        C memberC = new C(null);
        this.memberSet.add((Object)memberC);
        D memberD = new D("128");
        this.memberSet.add((Object)memberD);
        Assert.assertEquals((int)this.memberSet.size(), (int)4, (String)"Set had unexpected size");
        Iterator iterator = this.memberSet.iterator();
        try {
            iterator.remove();
            Assert.fail((String)"Should have seen a iterator exception, remove() called before first next()");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        iterator = this.memberSet.iterator();
        iterator.next();
        iterator.remove();
        try {
            iterator.remove();
            Assert.fail((String)"Should have seen a iterator exception, remove() called twice on same element");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testEqualsHash() {
        this.memberSet = new ClassIndexedSet();
        ClassIndexedSet other = new ClassIndexedSet();
        Assert.assertEquals(this.memberSet, (Set)other, (String)"Empty sets are equal");
        Assert.assertEquals((int)this.memberSet.hashCode(), (int)other.hashCode(), (String)"Empty sets have equal hashes");
        A memberA = new A("owner");
        B memberB = new B("algorithm");
        this.memberSet.add((Object)memberB);
        this.memberSet.add((Object)memberA);
        Assert.assertNotSame(this.memberSet, (Object)other, (String)"Different sets should differ");
        Assert.assertNotSame((Object)this.memberSet.hashCode(), (Object)other.hashCode(), (String)"Different sets should have different hashes ");
        other.add((Object)memberA);
        other.add((Object)memberB);
        Assert.assertEquals(this.memberSet, (Set)other, (String)"Equal sets are equal");
        Assert.assertEquals((int)this.memberSet.hashCode(), (int)other.hashCode(), (String)"Equal sets have equal hashes");
    }

    private class D
    extends AbstractMember {
        public D(String newData) {
            super(newData);
        }
    }

    private class C
    extends AbstractMember {
        public C(String newData) {
            super(newData);
        }
    }

    private class B
    extends AbstractMember {
        public B(String newData) {
            super(newData);
        }
    }

    private class A
    extends AbstractMember {
        public A(String newData) {
            super(newData);
        }
    }

    private abstract class AbstractMember
    implements Member {
        private String data;

        public AbstractMember(String newData) {
            this.data = newData;
        }

        @Override
        public String getData() {
            return this.data;
        }
    }

    private static interface Member {
        public String getData();
    }
}

