/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.codec;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.commons.codec.binary.Base64;

public final class Base64Support {
    public static final boolean CHUNKED = true;
    public static final boolean UNCHUNKED = false;
    @Nonnull
    private static final Base64 CHUNKED_ENCODER = new Base64(76, new byte[]{10});
    @Nonnull
    private static final Base64 UNCHUNKED_ENCODER = new Base64(0, new byte[]{10});

    private Base64Support() {
    }

    @Nonnull
    public static String encode(@Nonnull byte[] data, boolean chunked) {
        Constraint.isNotNull(data, "Binary data to be encoded can not be null");
        if (chunked) {
            return Constraint.isNotNull(StringSupport.trim(CHUNKED_ENCODER.encodeToString(data)), "Encoded data was null");
        }
        return Constraint.isNotNull(StringSupport.trim(UNCHUNKED_ENCODER.encodeToString(data)), "Encoded data was null");
    }

    @Nonnull
    public static byte[] decode(@Nonnull String data) throws DecodingException {
        Constraint.isNotNull(data, "Base64 encoded data can not be null");
        try {
            byte[] decoded = CHUNKED_ENCODER.decode(data);
            if (null == decoded) {
                throw new DecodingException("Base64 decoded data was null");
            }
            return decoded;
        }
        catch (Exception e) {
            throw new DecodingException("Unable to base64 decode data: " + e.getMessage(), e);
        }
    }

    @Nonnull
    public static String encodeURLSafe(@Nonnull byte[] data) {
        String s = Base64Support.encode(data, false);
        s = s.split("=")[0];
        s = s.replace('+', '-');
        s = s.replace('/', '_');
        return s;
    }

    @Nonnull
    public static byte[] decodeURLSafe(@Nonnull String data) throws DecodingException {
        Object s = Constraint.isNotNull(data, "Base64URL encoded data can not be null");
        s = ((String)s).replace('-', '+');
        s = ((String)s).replace('_', '/');
        switch (((String)s).length() % 4) {
            case 0: {
                break;
            }
            case 2: {
                s = (String)s + "==";
                break;
            }
            case 3: {
                s = (String)s + "=";
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Base64URL string!");
            }
        }
        return Base64Support.decode((String)s);
    }
}

