/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import javax.script.ScriptException;
import net.shibboleth.utilities.java.support.logic.ScriptedFunction;
import net.shibboleth.utilities.java.support.logic.ScriptedPredicate;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ScriptedTest {
    private static final String returnSelf = "input";
    private static final String returnSelfString = "input.toString()";
    private static final String returnCustom = "custom";

    @Test
    public void testPredicate() throws ScriptException {
        ScriptedPredicate test = ScriptedPredicate.inlineScript((String)returnSelf);
        Assert.assertTrue((boolean)test.apply((Object)Boolean.TRUE));
        Assert.assertFalse((boolean)test.apply((Object)Boolean.FALSE));
        Assert.assertFalse((boolean)test.apply((Object)new Integer(1)));
        test.setReturnOnError(true);
        Assert.assertTrue((boolean)test.apply((Object)new Integer(1)));
    }

    @Test
    public void testPredicateCustom() throws ScriptException {
        ScriptedPredicate test = ScriptedPredicate.inlineScript((String)returnCustom);
        test.setCustomObject((Object)Boolean.TRUE);
        Assert.assertTrue((boolean)test.apply((Object)Boolean.FALSE));
        test.setCustomObject((Object)Boolean.FALSE);
        Assert.assertFalse((boolean)test.apply((Object)Boolean.TRUE));
        test.setCustomObject((Object)new Integer(1));
        Assert.assertFalse((boolean)test.apply((Object)"true"));
        test.setReturnOnError(true);
        Assert.assertTrue((boolean)test.apply((Object)"false"));
    }

    @Test
    public void testBadScriptPredicate() throws ScriptException {
        ScriptedPredicate test = ScriptedPredicate.inlineScript((String)returnSelfString);
        test.setHideExceptions(true);
        test.setReturnOnError(true);
        Assert.assertTrue((boolean)test.apply(null));
        test.setReturnOnError(false);
        Assert.assertFalse((boolean)test.apply(null));
        test.setHideExceptions(false);
        try {
            Assert.assertFalse((boolean)test.apply(null));
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals(e.getCause().getClass(), ScriptException.class);
        }
    }

    @Test
    public void testFunction() throws ScriptException {
        ScriptedFunction test = ScriptedFunction.inlineScript((String)returnSelf);
        Assert.assertEquals((Object)test.apply((Object)Boolean.FALSE), (Object)Boolean.FALSE);
        Assert.assertEquals((Object)test.apply((Object)Boolean.TRUE), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)test.apply((Object)new Integer(1)), (Object)new Integer(1));
        test.setOutputType(Boolean.class);
        Assert.assertEquals((Object)test.apply((Object)Boolean.FALSE), (Object)Boolean.FALSE);
        Assert.assertEquals((Object)test.apply((Object)Boolean.TRUE), (Object)Boolean.TRUE);
        Assert.assertNotEquals((Object)test.apply((Object)new Integer(1)), (Object)new Integer(1));
        test.setReturnOnError((Object)Boolean.TRUE);
        Assert.assertEquals((Object)test.apply((Object)new Integer(1)), (Object)Boolean.TRUE);
        test.setReturnOnError((Object)Boolean.TRUE);
        test.setOutputType(Integer.class);
        test.setInputType(Integer.class);
        Assert.assertEquals((Object)test.apply((Object)Boolean.FALSE), (Object)Boolean.TRUE);
    }

    @Test
    public void testFunctionCustom() throws ScriptException {
        ScriptedFunction test = ScriptedFunction.inlineScript((String)returnCustom);
        test.setReturnOnError((Object)new Integer(99));
        test.setOutputType(Integer.class);
        test.setInputType(Integer.class);
        test.setCustomObject((Object)12);
        Assert.assertEquals((Object)test.apply((Object)false), (Object)99);
        Assert.assertEquals((Object)test.apply((Object)1), (Object)12);
        test.setCustomObject((Object)false);
        Assert.assertEquals((Object)test.apply((Object)false), (Object)99);
    }

    @Test
    public void testBadScriptFunction() throws ScriptException {
        ScriptedFunction test = ScriptedFunction.inlineScript((String)returnSelfString);
        test.setOutputType(Boolean.class);
        test.setInputType(Boolean.class);
        test.setHideExceptions(true);
        test.setReturnOnError((Object)true);
        Assert.assertEquals((Object)test.apply(null), (Object)true);
        test.setReturnOnError((Object)false);
        Assert.assertEquals((Object)test.apply(null), (Object)false);
        test.setHideExceptions(false);
        try {
            Assert.assertEquals((Object)test.apply(null), (Object)true);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals(e.getCause().getClass(), ScriptException.class);
        }
    }
}

