/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import java.util.Timer;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import net.shibboleth.utilities.java.support.httpclient.IdleConnectionSweeper;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IdleConectionSweeperTest {
    private final long SWEEP_INTERVAL = 50L;

    @Test(enabled=false)
    public void test() throws Exception {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        IdleConnectionSweeper sweeper = new IdleConnectionSweeper((HttpClientConnectionManager)connectionManager, 30L, 50L);
        Thread.sleep(200L);
        Assert.assertTrue((sweeper.scheduledExecutionTime() + 50L >= System.currentTimeMillis() ? 1 : 0) != 0);
        sweeper.destroy();
        Assert.assertTrue((boolean)sweeper.isDestroyed());
        try {
            sweeper.scheduledExecutionTime();
            Assert.fail();
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
        Timer timer = new Timer(true);
        sweeper = new IdleConnectionSweeper((HttpClientConnectionManager)connectionManager, 30L, 50L, timer);
        Thread.sleep(150L);
        Assert.assertTrue((sweeper.scheduledExecutionTime() + 50L >= System.currentTimeMillis() ? 1 : 0) != 0);
        sweeper.destroy();
        Assert.assertTrue((boolean)sweeper.isDestroyed());
        try {
            sweeper.scheduledExecutionTime();
            Assert.fail();
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
    }
}

