/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.client.cache.FileResourceFactory;
import org.apache.http.impl.client.cache.ManagedHttpCacheStorage;

public class FileCachingHttpClientBuilder
extends HttpClientBuilder {
    private File cacheDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "wwwcache");
    private int maxCacheEntries = 100;
    private long maxCacheEntrySize = 0xA00000L;

    public FileCachingHttpClientBuilder() {
        this(CachingHttpClientBuilder.create());
    }

    public FileCachingHttpClientBuilder(@Nonnull CachingHttpClientBuilder builder) {
        super((org.apache.http.impl.client.HttpClientBuilder)builder);
    }

    public File getCacheDirectory() {
        return this.cacheDir;
    }

    public void setCacheDirectory(@Nonnull @NotEmpty String directoryPath) {
        String trimmedPath = Constraint.isNotNull(StringSupport.trimOrNull(directoryPath), "Cache directory path can not be null or empty");
        this.cacheDir = new File(trimmedPath);
    }

    public void setCacheDirectory(@Nonnull File directory) {
        this.cacheDir = Constraint.isNotNull(directory, "Cache directory can not be null");
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMaxCacheEntries(int maxEntries) {
        this.maxCacheEntries = (int)Constraint.isGreaterThan(0L, maxEntries, "Maximum number of cache entries must be greater than 0");
    }

    public long getMaxCacheEntrySize() {
        return this.maxCacheEntrySize;
    }

    public void setMaxCacheEntrySize(long size) {
        this.maxCacheEntrySize = (int)Constraint.isGreaterThan(0L, size, "Maximum cache entry size must be greater than 0");
    }

    @Override
    protected void decorateApacheBuilder() throws Exception {
        super.decorateApacheBuilder();
        if (!this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
            throw new IOException("Unable to create cache directory " + this.cacheDir.getAbsolutePath());
        }
        if (!this.cacheDir.canRead()) {
            throw new IOException("Cache directory '" + this.cacheDir.getAbsolutePath() + "' is not readable");
        }
        if (!this.cacheDir.canWrite()) {
            throw new IOException("Cache directory '" + this.cacheDir.getAbsolutePath() + "' is not writable");
        }
        CachingHttpClientBuilder cachingBuilder = (CachingHttpClientBuilder)this.getApacheBuilder();
        CacheConfig.Builder cacheConfigBuilder = CacheConfig.custom();
        cacheConfigBuilder.setMaxCacheEntries(this.maxCacheEntries);
        cacheConfigBuilder.setMaxObjectSize(this.maxCacheEntrySize);
        cacheConfigBuilder.setHeuristicCachingEnabled(false);
        cacheConfigBuilder.setSharedCache(false);
        CacheConfig cacheConfig = cacheConfigBuilder.build();
        cachingBuilder.setCacheConfig(cacheConfig);
        cachingBuilder.setResourceFactory((ResourceFactory)new FileResourceFactory(this.cacheDir));
        cachingBuilder.setHttpCacheStorage((HttpCacheStorage)new ManagedHttpCacheStorage(cacheConfig));
    }
}

