/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.xml;

import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class QNameSupport {
    private QNameSupport() {
    }

    @Nonnull
    public static QName constructQName(@Nonnull Element owningElement, @Nonnull String qname) {
        String name;
        String nsPrefix;
        Constraint.isNotNull(owningElement, "Owning element may not be null");
        Constraint.isNotNull(qname, "Name may not be null");
        if (qname.indexOf(":") > -1) {
            StringTokenizer qnameTokens = new StringTokenizer(qname, ":");
            nsPrefix = StringSupport.trim(qnameTokens.nextToken());
            name = qnameTokens.nextToken();
        } else {
            nsPrefix = null;
            name = qname;
        }
        String nsURI = owningElement.lookupNamespaceURI(nsPrefix);
        return QNameSupport.constructQName(nsURI, name, nsPrefix);
    }

    @Nonnull
    public static QName constructQName(@Nullable String namespaceURI, @Nonnull String localName, @Nullable String prefix) {
        String trimmedLocalName = Constraint.isNotNull(StringSupport.trimOrNull(localName), "Local name may not be null");
        String trimmedPrefix = StringSupport.trimOrNull(prefix);
        if (trimmedPrefix == null) {
            return new QName(StringSupport.trimOrNull(namespaceURI), trimmedLocalName);
        }
        return new QName(StringSupport.trimOrNull(namespaceURI), trimmedLocalName, trimmedPrefix);
    }

    @Nullable
    public static QName getNodeQName(@Nullable Node domNode) {
        if (domNode == null) {
            return null;
        }
        return QNameSupport.constructQName(domNode.getNamespaceURI(), domNode.getLocalName(), domNode.getPrefix());
    }

    @Nonnull
    public static String qnameToContentString(@Nonnull QName qname) {
        Constraint.isNotNull(qname, "QName may not be null");
        StringBuffer buf = new StringBuffer();
        String s = StringSupport.trimOrNull(qname.getPrefix());
        if (s != null) {
            buf.append(qname.getPrefix());
            buf.append(":");
        }
        buf.append(qname.getLocalPart());
        return buf.toString();
    }
}

