/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resource.AbstractResource;
import net.shibboleth.utilities.java.support.resource.ResourceException;

public class FilesystemResource
extends AbstractResource {
    private final File resourceFile;

    public FilesystemResource(@Nonnull String resourcePath) {
        this.resourceFile = new File(Constraint.isNotNull(StringSupport.trimOrNull(resourcePath), "Resource file path may not be null or empty"));
        this.setLocation(this.resourceFile.getAbsolutePath());
    }

    @Override
    protected boolean doExists() throws ResourceException {
        return this.resourceFile.exists();
    }

    @Override
    protected InputStream doGetInputStream() throws ResourceException {
        try {
            return new FileInputStream(this.resourceFile);
        }
        catch (FileNotFoundException e) {
            throw new ResourceException("Resource file " + this.resourceFile.getPath() + " can not be read", e);
        }
    }

    @Override
    protected long doGetLastModifiedTime() throws ResourceException {
        return this.resourceFile.lastModified();
    }
}

