/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.UrlBuilder;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public final class SimpleUrlCanonicalizer {
    private static Map<String, Integer> schemePortMap = new HashMap<String, Integer>();

    private SimpleUrlCanonicalizer() {
    }

    public static void registerSchemePortMapping(@Nonnull @NotEmpty String scheme, @Nonnull Integer port) {
        String trimmedScheme = Constraint.isNotNull(StringSupport.trimOrNull(scheme), "Scheme cannot be null");
        Constraint.isNotNull(port, "Port cannot be null");
        schemePortMap.put(trimmedScheme.toLowerCase(), port);
    }

    public static void deregisterSchemePortMapping(@Nonnull String scheme) {
        String trimmedScheme = Constraint.isNotNull(StringSupport.trimOrNull(scheme), "Scheme cannot be null");
        schemePortMap.remove(trimmedScheme.toLowerCase());
    }

    @Nullable
    public static Integer getRegisteredPort(@Nonnull @NotEmpty String scheme) {
        String trimmedScheme = Constraint.isNotNull(StringSupport.trimOrNull(scheme), "Scheme cannot be null");
        return schemePortMap.get(trimmedScheme.toLowerCase());
    }

    @Nonnull
    @NotEmpty
    public static String canonicalize(@Nonnull @NotEmpty String url) throws MalformedURLException {
        Constraint.isFalse(Strings.isNullOrEmpty((String)url), "URL was null or empty");
        UrlBuilder urlBuilder = new UrlBuilder(url);
        SimpleUrlCanonicalizer.canonicalize(urlBuilder);
        return urlBuilder.buildURL();
    }

    private static void canonicalize(@Nonnull UrlBuilder url) {
        if (url.getScheme() != null) {
            url.setScheme(url.getScheme().toLowerCase());
            String scheme = url.getScheme();
            Integer port = SimpleUrlCanonicalizer.getRegisteredPort(scheme);
            if (port != null && port.equals(url.getPort())) {
                url.setPort(null);
            }
        }
        if (url.getHost() != null) {
            url.setHost(url.getHost().toLowerCase());
        }
    }

    static {
        SimpleUrlCanonicalizer.registerSchemePortMapping("ftp", 23);
        SimpleUrlCanonicalizer.registerSchemePortMapping("http", 80);
        SimpleUrlCanonicalizer.registerSchemePortMapping("https", 443);
        SimpleUrlCanonicalizer.registerSchemePortMapping("ldap", 389);
        SimpleUrlCanonicalizer.registerSchemePortMapping("ldaps", 636);
    }
}

