/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.component;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public abstract class AbstractIdentifiableInitializableComponent
extends AbstractInitializableComponent
implements IdentifiableComponent {
    private String id;

    @Override
    public String getId() {
        return this.id;
    }

    protected synchronized void setId(@Nonnull @NotEmpty String componentId) {
        if (this.isInitialized()) {
            return;
        }
        this.id = Constraint.isNotNull(StringSupport.trimOrNull(componentId), "Component ID can not be null or empty");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getId() == null) {
            throw new ComponentInitializationException("Component identifier can not be null");
        }
    }
}

