/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl.AbstractOIDCUserInfoValidationResponseAction;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.oidc.profile.config.navigate.IssuedClaimsValidatorLookupFunction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateAccessToken
extends AbstractOIDCUserInfoValidationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateAccessToken.class);
    @Nonnull
    private Function<ProfileRequestContext, ClaimsValidator> claimsValidatorLookupStrategy = new IssuedClaimsValidatorLookupFunction();
    @Nullable
    private ClaimsValidator claimsValidator;

    public void setClaimsValidatorLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsValidator> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.claimsValidatorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.claimsValidator = this.claimsValidatorLookupStrategy.apply(profileRequestContext);
        if (this.claimsValidator == null) {
            this.log.error("{} Unable to obtain ClaimsValidator to apply", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        TokenClaimsSet tokenClaims = this.getOidcResponseContext().getAuthorizationGrantClaimsSet();
        if (!(tokenClaims instanceof AccessTokenClaimsSet) || tokenClaims.getClaimsSet() == null) {
            this.log.error("{} Claims validation failed, unable to locate access token claims set to validate", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        this.log.debug("{} Validating parsed/decoded claims set: {}", (Object)this.getLogPrefix(), (Object)tokenClaims.getClaimsSet().toString());
        try {
            this.claimsValidator.validate(tokenClaims.getClaimsSet(), profileRequestContext);
        }
        catch (JWTValidationException e) {
            this.log.warn("{} Claims validation failed, token is invalid: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        this.log.debug("{} Access token {} validated", (Object)this.getLogPrefix(), (Object)tokenClaims.getID());
    }
}

