/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.util.Collections;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl.ParseAccessToken;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.security.credential.BasicJWKCredential;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.springframework.webflow.execution.Event;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ParseAccessTokenTest
extends BaseOIDCResponseActionTest {
    RSAPrivateKey rsaPrivateKey;
    RSAPublicKey rsaPublicKey;
    private ParseAccessToken action;

    @BeforeClass
    public void initKeys() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        KeyPair keyPair = keyGen.genKeyPair();
        this.rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        this.rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
    }

    @BeforeMethod
    private void init() throws ComponentInitializationException, NoSuchAlgorithmException {
        this.action = new ParseAccessToken();
        this.action.setDataSealer(this.getDataSealer());
        this.action.setCredentialResolver(new CredentialResolver(){

            public Iterable<Credential> resolve(CriteriaSet criteria) throws ResolverException {
                return Collections.singletonList(this.resolveSingle(criteria));
            }

            public Credential resolveSingle(CriteriaSet criteria) throws ResolverException {
                BasicJWKCredential cred = new BasicJWKCredential();
                cred.setPublicKey((PublicKey)ParseAccessTokenTest.this.rsaPublicKey);
                cred.setPrivateKey((PrivateKey)ParseAccessTokenTest.this.rsaPrivateKey);
                return cred;
            }
        });
        this.action.initialize();
    }

    @Test
    public void testSuccess() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, DataSealerException {
        TokenClaimsSet claims = new AccessTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now().plusSeconds(1L)).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).build();
        BearerAccessToken token = new BearerAccessToken(claims.serialize(this.getDataSealer()));
        UserInfoRequest req = new UserInfoRequest(new URI("http://example.com"), (AccessToken)token);
        this.setUserInfoRequest(req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testJWT() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, DataSealerException, JOSEException {
        String sealedClaims = this.getDataSealer().wrap(new JWTClaimsSet.Builder().claim("prncpl", (Object)"userPrin").build().toString());
        TokenClaimsSet claims = new AccessTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now().plusSeconds(1L)).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).addCustomClaim("for_op", (Object)sealedClaims).build();
        RSASSASigner signer = new RSASSASigner((PrivateKey)this.rsaPrivateKey);
        JWSHeader.Builder headerBuilder = new JWSHeader.Builder(new JWSAlgorithm("RS256")).type(new JOSEObjectType("at+jwt"));
        SignedJWT jwt = new SignedJWT(headerBuilder.build(), claims.getClaimsSet());
        jwt.sign((JWSSigner)signer);
        BearerAccessToken token = new BearerAccessToken(jwt.serialize());
        UserInfoRequest req = new UserInfoRequest(new URI("http://example.com"), (AccessToken)token);
        this.setUserInfoRequest(req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        headerBuilder = new JWSHeader.Builder(new JWSAlgorithm("RS256"));
        jwt = new SignedJWT(headerBuilder.build(), claims.getClaimsSet());
        jwt.sign((JWSSigner)signer);
        token = new BearerAccessToken(jwt.serialize());
        req = new UserInfoRequest(new URI("http://example.com"), (AccessToken)token);
        this.setUserInfoRequest(req);
        event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidGrant");
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        KeyPair keyPair = keyGen.genKeyPair();
        signer = new RSASSASigner(keyPair.getPrivate());
        headerBuilder = new JWSHeader.Builder(new JWSAlgorithm("RS256")).type(new JOSEObjectType("at+jwt"));
        jwt = new SignedJWT(headerBuilder.build(), claims.getClaimsSet());
        jwt.sign((JWSSigner)signer);
        token = new BearerAccessToken(jwt.serialize());
        req = new UserInfoRequest(new URI("http://example.com"), (AccessToken)token);
        this.setUserInfoRequest(req);
        event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidGrant");
    }

    @Test
    public void testFailsNotAccessToken() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException, DataSealerException {
        TokenClaimsSet claims = new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now().plusSeconds(1L)).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).build();
        BearerAccessToken token = new BearerAccessToken(claims.serialize(this.getDataSealer()));
        UserInfoRequest req = new UserInfoRequest(new URI("http://example.com"), (AccessToken)token);
        this.setUserInfoRequest(req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidGrant");
    }
}

