/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import java.net.URISyntaxException;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl.FormOutboundUserInfoResponseMessage;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.MessageContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FormOutboundUserInfoResponseMessageTest
extends BaseOIDCResponseActionTest {
    private FormOutboundUserInfoResponseMessage action;

    @BeforeMethod
    public void init() throws ComponentInitializationException, URISyntaxException, ParseException, JOSEException {
        this.action = new FormOutboundUserInfoResponseMessage();
        this.action.initialize();
        this.setUserInfoResponseToResponseContext("joe");
        this.signUserInfoResponseInResponseContext();
    }

    @Test
    public void testSuccessMessageSigned() throws ComponentInitializationException, URISyntaxException, ParseException, JOSEException {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        UserInfoResponse resp = (UserInfoResponse)((MessageContext)this.respCtx.getParent()).getMessage();
        Assert.assertNotNull((Object)resp);
        Assert.assertNotNull((Object)resp.toSuccessResponse().getUserInfoJWT());
        Assert.assertNull((Object)resp.toSuccessResponse().getUserInfo());
    }

    @Test
    public void testSuccessMessagePlain() throws ComponentInitializationException, URISyntaxException, ParseException, JOSEException {
        this.respCtx.setProcessedToken(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        UserInfoResponse resp = (UserInfoResponse)((MessageContext)this.respCtx.getParent()).getMessage();
        Assert.assertNotNull((Object)resp);
        Assert.assertNotNull((Object)resp.toSuccessResponse().getUserInfo());
        Assert.assertNull((Object)resp.toSuccessResponse().getUserInfoJWT());
    }

    @Test
    public void testFailNoMessage() throws ComponentInitializationException, URISyntaxException, ParseException, JOSEException {
        this.respCtx.setProcessedToken(null);
        this.respCtx.setUserInfo(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
    }
}

