/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.security.impl;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import net.shibboleth.idp.plugin.oidc.op.criterion.ClientInformationCriterion;
import net.shibboleth.idp.plugin.oidc.op.profile.spring.factory.BasicJWKCredentialFactoryBean;
import net.shibboleth.idp.plugin.oidc.op.security.impl.OIDCClientInformationEncryptionParametersResolver;
import net.shibboleth.oidc.jwk.RemoteJwkSetCache;
import net.shibboleth.oidc.security.impl.OIDCDecryptionParameters;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.mockito.Mockito;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OIDCClientInformationEncryptionParametersResolverTest
extends OpenSAMLInitBaseTestCase {
    private OIDCClientInformationEncryptionParametersResolver resolver;
    private CriteriaSet criteria;
    private OIDCClientMetadata metaData;
    private JWKSet jwkSet;

    @BeforeMethod
    protected void setUp() throws ParseException {
        this.jwkSet = JWKSet.parse((String)"{\n  \"keys\": [\n    {\n      \"kty\": \"EC\",\n      \"d\": \"MeEUizlBfHEfftMzSUYmtltJr87NUn2WZqxKDVPMlxM\",\n      \"crv\": \"P-256\",\n      \"x\": \"psUf_1U4lV0u2zSRjVepDMyLV4JeLoWNcz3F3C91z4Y\",\n      \"y\": \"z29JaoRl_1wgGPEKq7-5qvts9vbEwA7hk5Vg01h8ESc\"\n    },\n    {\n      \"kty\": \"RSA\",\n      \"kid\": \"testRsaKey\",\n      \"d\": \"RBl-MjdugxTrjVbbWSeArOV7HUiZPX5LWmyB9p3P1OLSSYjK9A42KYPsdcLpa78Den5_fcpLv-1pm8161ATE9Y_O2aIkeg0_IRlM-FLo-KHvtGkEuHcbERPGhrvmsyMsqkVGADhEwvcGsWZ9PZSHo8OK8EsHZWmE2kHN_rG_8n9-ymAvdsHHv5WhyppHtScLWR1UoIQVbnmcw0cauBy-6SYL2pnweWMeI5UDB6eYyeUyA8BuV-_40K0XqJgJ--6zkNdsSrAMbOejfSyAgK7ezCCP-gmS2P3tBLqwJKjCcoDGFihHj6qLUFNWDY5flp3vA02Z8DQKroeAtIN0_PSBIQ\",\n      \"e\": \"AQAB\",\n      \"n\": \"xC18p5gfcin62WKas_DlmwUE0ySwmgW51gDQhqucBBSyHMvzRXzRY1cYkox4WCLreC3X8YbNgAv9fjkagX35aNyafnJxEd3Cipf6-h_tZ8Ky5mtdKrxpJdGW1mom7Ha8nMAFGmElDtQny2U8pzDUAUvOcOjiI-JRd6WH3wyQtpCtG6YYxhS9SvnvDaNlYN_afPgFdTHt5yn-q854bjF6uG-uZt3J7jf7P6dvqVizDVO9xtCHrjeet4v62yscMZXYi110aMJdtA4nxKGUi9RWCnBoLVRMBei5ZqmsLCozT5KpfVNkjVzZU3vYBKdGw49pIgRqQP-Jx8Sg7JFaaXMBsQ\"\n    }  ]\n}");
    }

    protected void initTest(RemoteJwkSetCache remoteJwkSetCache) throws Exception {
        this.resolver = new OIDCClientInformationEncryptionParametersResolver();
        ArrayList<EncryptionConfiguration> configs = new ArrayList<EncryptionConfiguration>();
        EncryptionConfiguration encConfig = (EncryptionConfiguration)Mockito.mock(EncryptionConfiguration.class);
        Mockito.when((Object)encConfig.getDataEncryptionAlgorithms()).thenReturn(Arrays.asList("A128CBC-HS256", "A192CBC-HS384", "A256CBC-HS512", "A128GCM", "A192GCM", "A256GCM"));
        Mockito.when((Object)encConfig.getKeyTransportEncryptionAlgorithms()).thenReturn(Arrays.asList("ECDH-ES", "RSA1_5", "RSA-OAEP", "RSA-OAEP-256", "A128GCMKW", "A192GCMKW", "A256GCMKW"));
        ArrayList<Credential> encCreds = new ArrayList<Credential>();
        BasicJWKCredentialFactoryBean factory = new BasicJWKCredentialFactoryBean();
        factory.setResource((Resource)new ClassPathResource("credentials/idp-encryption-rsa.jwk"));
        factory.afterPropertiesSet();
        encCreds.add((Credential)factory.getObject());
        Mockito.when((Object)encConfig.getKeyTransportEncryptionCredentials()).thenReturn(encCreds);
        configs.add(encConfig);
        this.criteria = new CriteriaSet(new Criterion[]{new EncryptionConfigurationCriterion(configs)});
        this.metaData = new OIDCClientMetadata();
        this.metaData.setIDTokenJWEAlg(JWEAlgorithm.RSA_OAEP_256);
        this.metaData.setIDTokenJWEEnc(EncryptionMethod.A192CBC_HS384);
        this.metaData.setUserInfoJWEAlg(JWEAlgorithm.A128GCMKW);
        this.metaData.setUserInfoJWEEnc(EncryptionMethod.A128GCM);
        this.metaData.setRequestObjectJWEAlg(JWEAlgorithm.RSA_OAEP_256);
        this.metaData.setRequestObjectJWEEnc(EncryptionMethod.A192GCM);
        if (remoteJwkSetCache != null) {
            this.resolver.setRemoteJwkSetCache(remoteJwkSetCache);
            this.metaData.setJWKSetURI(new URI("https://rp.example.org/jwks"));
        } else {
            this.metaData.setJWKSet(this.jwkSet);
        }
        OIDCClientInformation clientInformation = new OIDCClientInformation(new ClientID(), new Date(), this.metaData, new Secret("abcdefgh"));
        this.criteria.add((Object)new ClientInformationCriterion(clientInformation));
    }

    @Test
    public void testIdTokenParameters() throws Exception {
        this.initTest(null);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)"RSA-OAEP-256", (String)params.getKeyTransportEncryptionAlgorithm());
        Assert.assertEquals((String)"A192CBC-HS384", (String)params.getDataEncryptionAlgorithm());
        Assert.assertEquals((Object)((RSAKey)this.jwkSet.getKeyByKeyId("testRsaKey")).toPublicKey(), (Object)params.getKeyTransportEncryptionCredential().getPublicKey());
    }

    @Test
    public void testIdTokenParametersRemoteKey() throws Exception {
        RemoteJwkSetCache remoteJwkSetCache = (RemoteJwkSetCache)Mockito.mock(RemoteJwkSetCache.class);
        Mockito.when((Object)remoteJwkSetCache.fetch((URI)Mockito.any(), (Instant)Mockito.any())).thenReturn((Object)this.jwkSet);
        this.initTest(remoteJwkSetCache);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)"RSA-OAEP-256", (String)params.getKeyTransportEncryptionAlgorithm());
        Assert.assertEquals((String)"A192CBC-HS384", (String)params.getDataEncryptionAlgorithm());
        Assert.assertEquals((Object)((RSAKey)this.jwkSet.getKeyByKeyId("testRsaKey")).toPublicKey(), (Object)params.getKeyTransportEncryptionCredential().getPublicKey());
    }

    @Test
    public void testIdTokenParametersNoKey() throws Exception {
        RemoteJwkSetCache remoteJwkSetCache = (RemoteJwkSetCache)Mockito.mock(RemoteJwkSetCache.class);
        Mockito.when((Object)remoteJwkSetCache.fetch((URI)Mockito.any(), (Instant)Mockito.any())).thenReturn(null);
        this.initTest(remoteJwkSetCache);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteria);
        Assert.assertNotEquals((Object)((RSAKey)this.jwkSet.getKeyByKeyId("testRsaKey")).toPublicKey(), (Object)params.getKeyTransportEncryptionCredential().getPublicKey());
    }

    @Test
    public void testIdTokenParametersDefaultEnc() throws Exception {
        this.initTest(null);
        this.metaData.setIDTokenJWEEnc(null);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)"RSA-OAEP-256", (String)params.getKeyTransportEncryptionAlgorithm());
        Assert.assertEquals((String)"A128CBC-HS256", (String)params.getDataEncryptionAlgorithm());
        Assert.assertNotNull((Object)params.getKeyTransportEncryptionCredential().getPublicKey());
    }

    @Test
    public void testUserInfoParameters() throws Exception {
        this.initTest(null);
        this.resolver.setParameterType(OIDCClientInformationEncryptionParametersResolver.ParameterType.USERINFO_ENCRYPTION);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)"A128GCMKW", (String)params.getKeyTransportEncryptionAlgorithm());
        Assert.assertEquals((String)"A128GCM", (String)params.getDataEncryptionAlgorithm());
        Assert.assertNotNull((Object)params.getKeyTransportEncryptionCredential().getSecretKey());
    }

    @Test
    public void testRequesrObjectParameters() throws Exception {
        this.initTest(null);
        this.resolver.setParameterType(OIDCClientInformationEncryptionParametersResolver.ParameterType.REQUEST_OBJECT_DECRYPTION);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteria);
        Assert.assertEquals((String)"RSA-OAEP-256", (String)params.getKeyTransportEncryptionAlgorithm());
        Assert.assertEquals((String)"A192GCM", (String)params.getDataEncryptionAlgorithm());
        Assert.assertNotNull((Object)((Credential)((OIDCDecryptionParameters)params).getKeyTransportDecryptionCredentials().get(0)).getPrivateKey());
    }
}

