/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultTokenRevocationLifetimeLookupStrategy;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultTokenRevocationLifetimeLookupStrategyTest {
    DefaultTokenRevocationLifetimeLookupStrategy function;

    protected void initFunction(Duration clockSkew) {
        this.function = new DefaultTokenRevocationLifetimeLookupStrategy();
        this.function.setClockSkew(clockSkew);
    }

    protected JWTClaimsSet buildClaimsSet(Instant exp) {
        return new JWTClaimsSet.Builder().issuer("mockIssuer").expirationTime(exp == null ? null : Date.from(exp)).build();
    }

    @Test
    public void testNullReturnsNull() {
        this.initFunction(Duration.ZERO);
        Assert.assertNull((Object)this.function.apply(null));
    }

    @Test
    public void testNullExpReturnsNull() {
        this.initFunction(Duration.ZERO);
        Assert.assertNull((Object)this.function.apply(this.buildClaimsSet(null)));
    }

    @Test
    public void testExpiredReturnsZero() {
        this.initFunction(Duration.ZERO);
        Assert.assertEquals((Object)this.function.apply(this.buildClaimsSet(Instant.now().minusSeconds(5L))), (Object)Duration.ZERO);
    }

    @Test
    public void testExpiredWithClockSkewReturnsZero() {
        this.initFunction(Duration.ofSeconds(5L));
        Assert.assertEquals((Object)this.function.apply(this.buildClaimsSet(Instant.now().minusSeconds(10L))), (Object)Duration.ZERO);
    }

    @Test
    public void testExpiredButWithinClockSkewReturnsNonZero() {
        this.initFunction(Duration.ofSeconds(10L));
        Duration result = this.function.apply(this.buildClaimsSet(Instant.now().minusSeconds(5L)));
        Assert.assertFalse((result.isZero() || result.isNegative() ? 1 : 0) != 0);
    }

    @Test
    public void testUnExpiredButWithoutClockSkewReturnsNonZero() {
        this.initFunction(Duration.ZERO);
        Duration result = this.function.apply(this.buildClaimsSet(Instant.now().plusSeconds(5L)));
        Assert.assertFalse((result.isZero() || result.isNegative() ? 1 : 0) != 0);
    }

    @Test
    public void testUnExpiredButWithClockSkewReturnsNonZeroWithClockSkewPlusFiveMins() {
        Instant now = Instant.now();
        this.initFunction(Duration.ofMinutes(5L));
        Duration result = this.function.apply(this.buildClaimsSet(now.plusSeconds(5L)));
        Assert.assertFalse((boolean)result.minus(Duration.ofMinutes(10L)).isNegative());
    }
}

