/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.VerifyRequestedSubjectIdentifier;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VerifyRequestedSubjectIdentifierTest
extends BaseOIDCResponseActionTest {
    private VerifyRequestedSubjectIdentifier action;

    private void init() throws ComponentInitializationException {
        this.action = new VerifyRequestedSubjectIdentifier();
        this.action.initialize();
    }

    @Test
    public void testSuccessNoReqSubject() throws ComponentInitializationException {
        this.init();
        this.respCtx.setRequestedSubject(null);
        this.respCtx.setSubject(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getRequestedSubject());
    }

    @Test
    public void testNoGenSubject() throws ComponentInitializationException {
        this.init();
        this.respCtx.setRequestedSubject("reqsub");
        this.respCtx.setSubject(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubject");
    }

    @Test
    public void testNoMismatchSubject() throws ComponentInitializationException {
        this.init();
        this.respCtx.setRequestedSubject("reqsub");
        this.respCtx.setSubject("reqsub2");
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubject");
    }

    @Test
    public void testSuccess() throws ComponentInitializationException {
        this.init();
        this.respCtx.setRequestedSubject("reqsub");
        this.respCtx.setSubject("reqsub");
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }
}

