/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.ValidateRedirectURI;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ValidateRedirectURITest
extends BaseOIDCResponseActionTest {
    private ValidateRedirectURI action;
    private String requestUri = "https://client.example.org/cb";

    private void init() throws ComponentInitializationException, URISyntaxException {
        this.init(true, new URI(this.requestUri), null, null);
    }

    private void init(boolean requireRequestedValue, URI requestedUri, Set<URI> validUris, Set<URI> registeredUris) throws ComponentInitializationException {
        this.action = new ValidateRedirectURI();
        this.action.setRequireRequestedValue(requireRequestedValue);
        this.action.setRedirectURILookupStrategy(prc -> requestedUri);
        if (validUris != null) {
            this.action.setValidRedirectURIsLookupStrategy(prc -> validUris);
        }
        if (registeredUris != null) {
            this.action.setRegisteredRedirectURIsLookupStrategy(prc -> registeredUris);
        }
        this.action.initialize();
    }

    @Test
    public void testNoCtx() throws ComponentInitializationException, URISyntaxException {
        this.init();
        this.profileRequestCtx.getInboundMessageContext().removeSubcontext(OIDCMetadataContext.class);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRedirectionURI");
    }

    @Test
    public void testNoMatch() throws ComponentInitializationException, URISyntaxException {
        this.init();
        OIDCMetadataContext oidcCtx = (OIDCMetadataContext)this.profileRequestCtx.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class, true);
        OIDCClientMetadata metaData = new OIDCClientMetadata();
        metaData.setRedirectionURI(new URI("https://notmatching.org"));
        OIDCClientInformation information = new OIDCClientInformation(new ClientID("test"), null, metaData, null, null, null);
        oidcCtx.setClientInformation(information);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRedirectionURI");
        Assert.assertNull((Object)this.respCtx.getRedirectURI());
    }

    @Test
    public void testMatch() throws ComponentInitializationException, URISyntaxException {
        this.init();
        OIDCMetadataContext oidcCtx = (OIDCMetadataContext)this.profileRequestCtx.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class, true);
        OIDCClientMetadata metaData = new OIDCClientMetadata();
        metaData.setRedirectionURI(new URI("https://client.example.org/cb"));
        OIDCClientInformation information = new OIDCClientInformation(new ClientID("test"), null, metaData, null, null, null);
        oidcCtx.setClientInformation(information);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getRedirectURI());
    }

    @Test
    public void testNullRequesNotAllowed() throws ComponentInitializationException, URISyntaxException {
        this.init(true, null, Set.of(new URI(this.requestUri)), Set.of(new URI(this.requestUri)));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRedirectionURI");
        Assert.assertNull((Object)this.respCtx.getRedirectURI());
    }

    @Test
    public void testNullRequesAllowedNotSingleValidUri() throws ComponentInitializationException, URISyntaxException {
        this.init(false, null, Set.of(new URI(this.requestUri), new URI("https://another.example.org")), Set.of(new URI(this.requestUri)));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRedirectionURI");
        Assert.assertNull((Object)this.respCtx.getRedirectURI());
    }

    @Test
    public void testNullRequesAllowedNotSingleRegisteredUri() throws ComponentInitializationException, URISyntaxException {
        this.init(false, null, Set.of(new URI(this.requestUri)), Set.of(new URI(this.requestUri), new URI("https://another.example.org")));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRedirectionURI");
        Assert.assertNull((Object)this.respCtx.getRedirectURI());
    }

    @Test
    public void testNullRequesAllowedNoRegisteredUris() throws ComponentInitializationException, URISyntaxException {
        this.init(false, null, Set.of(new URI(this.requestUri)), null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRedirectionURI");
        Assert.assertNull((Object)this.respCtx.getRedirectURI());
    }

    @Test
    public void testNullRequesAllowed() throws ComponentInitializationException, URISyntaxException {
        this.init(false, null, Set.of(new URI(this.requestUri)), Set.of(new URI(this.requestUri)));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getRedirectURI());
        Assert.assertEquals((Object)this.respCtx.getRedirectURI(), (Object)new URI(this.requestUri));
    }
}

