/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.google.common.base.Predicates;
import java.util.HashSet;
import java.util.function.Predicate;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseConsentContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.SetConsentToResponseContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.profile.config.OIDCAuthorizationConfiguration;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SetConsentToResponseContextTest
extends BaseOIDCResponseActionTest {
    private SetConsentToResponseContext action;
    private AttributeContext attributeCtx;

    private void init(boolean encodeConsent, boolean consentEnabled) throws ComponentInitializationException {
        this.attributeCtx = new AttributeContext();
        HashSet<IdPAttribute> attributes = new HashSet<IdPAttribute>();
        attributes.add(new IdPAttribute("1"));
        attributes.add(new IdPAttribute("2"));
        this.attributeCtx.setIdPAttributes(attributes);
        this.rpCtx.addSubcontext((BaseContext)this.attributeCtx);
        ((OIDCAuthorizationConfiguration)this.rpCtx.getProfileConfig()).setEncodeConsentInTokens(encodeConsent);
        this.action = new SetConsentToResponseContext();
        this.action.setConsentEnabledPredicate((Predicate)(consentEnabled ? Predicates.alwaysTrue() : Predicates.alwaysFalse()));
        this.action.initialize();
    }

    @Test
    public void testWithEncodingDisabled() throws ComponentInitializationException {
        this.init(false, false);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getSubcontext(OIDCAuthenticationResponseConsentContext.class, false));
    }

    @Test
    public void testFailNoAttributeContext() throws ComponentInitializationException {
        this.init(true, true);
        ((RelyingPartyContext)this.profileRequestCtx.getSubcontext(RelyingPartyContext.class)).removeSubcontext(AttributeContext.class);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getSubcontext(OIDCAuthenticationResponseConsentContext.class, false));
    }

    @Test
    public void testNoAttributeReleaseFlow() throws ComponentInitializationException {
        this.init(true, false);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getSubcontext(OIDCAuthenticationResponseConsentContext.class, false));
    }

    @Test
    public void testSuccess() throws ComponentInitializationException {
        this.init(true, true);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        OIDCAuthenticationResponseConsentContext ctx = (OIDCAuthenticationResponseConsentContext)this.respCtx.getSubcontext(OIDCAuthenticationResponseConsentContext.class, false);
        Assert.assertNotNull((Object)ctx);
        Assert.assertTrue((boolean)ctx.getConsentedAttributes().contains((Object)"1"));
        Assert.assertTrue((boolean)ctx.getConsentedAttributes().contains((Object)"2"));
        Assert.assertTrue((ctx.getConsentedAttributes().size() == 2 ? 1 : 0) != 0);
    }
}

