/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.InitializeSubjectContext;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InitializeSubjectContextTest
extends BaseOIDCResponseActionTest {
    private InitializeSubjectContext action;

    private void init() throws ComponentInitializationException {
        this.action = new InitializeSubjectContext();
        this.action.initialize();
    }

    @Test
    public void testNoClaimsSet() throws ComponentInitializationException {
        this.init();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubject");
    }

    @Test
    public void testSuccess() throws ComponentInitializationException, URISyntaxException {
        this.init();
        TokenClaimsSet claims = new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject(this.subject).setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).build();
        this.respCtx.setAuthorizationGrantClaimsSet(claims);
        Event event = this.action.execute(this.requestCtx);
        SubjectContext ctx = (SubjectContext)this.profileRequestCtx.getSubcontext(SubjectContext.class);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)ctx.getPrincipalName(), (String)"userPrin");
    }
}

