/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformationResponse;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.time.Instant;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BuildClientInformation;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BuildClientInformationTest {
    protected BuildClientInformation action;
    protected ProfileRequestContext profileRequestCtx;
    protected MessageContext messageCtx;
    protected OIDCClientRegistrationResponseContext registrationCtx;
    protected OIDCClientMetadata metadata;
    protected String clientId;
    protected String clientSecret;

    @BeforeMethod
    public void setup() throws ComponentInitializationException {
        this.action = new BuildClientInformation();
        this.action.initialize();
        this.profileRequestCtx = new ProfileRequestContext();
        this.messageCtx = new MessageContext();
        Assert.assertNull((Object)this.messageCtx.getMessage());
        this.profileRequestCtx.setOutboundMessageContext(this.messageCtx);
        this.registrationCtx = (OIDCClientRegistrationResponseContext)this.profileRequestCtx.getOutboundMessageContext().getSubcontext(OIDCClientRegistrationResponseContext.class, true);
        this.clientId = "mockClientId";
        this.clientSecret = "mockSecret";
        this.metadata = new OIDCClientMetadata();
        this.registrationCtx.setClientId(this.clientId);
        this.registrationCtx.setClientSecret(this.clientSecret);
        this.registrationCtx.setClientMetadata(this.metadata);
    }

    @Test
    public void noOutboundMessageContext() {
        ProfileRequestContext localPrc = new ProfileRequestContext();
        this.action.execute(localPrc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)localPrc, (Object)"InvalidProfileContext");
    }

    @Test
    public void noMetadataContext() {
        ProfileRequestContext localPrc = new ProfileRequestContext();
        localPrc.setOutboundMessageContext(new MessageContext());
        this.action.execute(localPrc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)localPrc, (Object)"InvalidMessageContext");
    }

    @Test
    public void noClientIdInContext() {
        this.registrationCtx.setClientId(null);
        this.action.execute(this.profileRequestCtx);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.profileRequestCtx, (Object)"InvalidMessageContext");
    }

    @Test
    public void noClientMetadataInContext() {
        this.registrationCtx.setClientMetadata(null);
        this.action.execute(this.profileRequestCtx);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.profileRequestCtx, (Object)"InvalidMessageContext");
    }

    @Test
    public void noClientSecretInContextWhenRequired() {
        this.registrationCtx.setClientSecret(null);
        this.action.execute(this.profileRequestCtx);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.profileRequestCtx, (Object)"InvalidMessageContext");
    }

    @Test
    public void noClientSecretInContextRequiredWithPrivateKeyJWT() {
        this.registrationCtx.setClientSecret(null);
        this.metadata.setTokenEndpointAuthMethod(ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        this.action.execute(this.profileRequestCtx);
        this.assertSuccessfulResponse(false);
    }

    @Test
    public void noTokenEndpointAuthMethodCreatesSecret() {
        this.action.execute(this.profileRequestCtx);
        this.assertSuccessfulResponse();
    }

    @Test
    public void basicTokenEndpointAuthMethodCreatesSecret() {
        this.metadata.setTokenEndpointAuthMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        this.action.execute(this.profileRequestCtx);
        this.assertSuccessfulResponse();
    }

    @Test
    public void postTokenEndpointAuthMethodCreatesSecret() {
        this.metadata.setTokenEndpointAuthMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST);
        this.action.execute(this.profileRequestCtx);
        this.assertSuccessfulResponse();
    }

    @Test
    public void jwtSecretTokenEndpointAuthMethodCreatesSecret() {
        this.metadata.setTokenEndpointAuthMethod(ClientAuthenticationMethod.CLIENT_SECRET_JWT);
        this.action.execute(this.profileRequestCtx);
        this.assertSuccessfulResponse();
    }

    @Test
    public void noTokenEndpointAuthMethodCreatesSecret_expirationTimeIgnored() {
        this.registrationCtx.setClientSecretExpiresAt(Instant.now().plusSeconds(60L));
        this.action.execute(this.profileRequestCtx);
        this.assertSuccessfulResponse();
    }

    protected void assertSuccessfulResponse() {
        this.assertSuccessfulResponse(true);
    }

    protected void assertSuccessfulResponse(boolean secret) {
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.profileRequestCtx);
        OIDCClientInformationResponse response = (OIDCClientInformationResponse)this.messageCtx.getMessage();
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)response.getOIDCClientInformation().getID(), (Object)new ClientID(this.clientId));
        if (secret) {
            this.assertSecret(response);
        }
    }

    protected void assertSecret(OIDCClientInformationResponse response) {
        Secret secret = response.getOIDCClientInformation().getSecret();
        Assert.assertNotNull((Object)secret);
        Assert.assertEquals((String)secret.getValue(), (String)this.clientSecret);
        Assert.assertNull((Object)secret.getExpirationDate());
    }
}

