/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddRedirectUrisToClientMetadata;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCClientMetadataPopulationTest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddRedirectUrisToClientMetadataTest
extends BaseOIDCClientMetadataPopulationTest {
    AddRedirectUrisToClientMetadata action;
    URI redirectUri1;
    URI redirectUri2;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException, URISyntaxException {
        this.action = new AddRedirectUrisToClientMetadata();
        this.action.initialize();
        this.redirectUri1 = new URI("https://example.org/cb1");
        this.redirectUri2 = new URI("https://example.org/cb2");
    }

    @Override
    protected AbstractOIDCClientMetadataPopulationAction constructAction() {
        return new AddRedirectUrisToClientMetadata();
    }

    @Test
    public void testOne() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setRedirectionURI(this.redirectUri1);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Set resultUris = output.getRedirectionURIs();
        Assert.assertEquals((int)resultUris.size(), (int)1);
        Assert.assertEquals(resultUris.iterator().next(), (Object)this.redirectUri1);
    }

    @Test
    public void testSet() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        HashSet<URI> uris = new HashSet<URI>();
        uris.add(this.redirectUri1);
        uris.add(this.redirectUri2);
        input.setRedirectionURIs(uris);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Set resultUris = output.getRedirectionURIs();
        Assert.assertEquals((Set)resultUris, uris);
    }
}

