/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.flow;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.shibboleth.idp.plugin.oidc.op.profile.flow.AbstractOidcFlowTest;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfigurationFlowTest
extends AbstractOidcFlowTest {
    public static final String FLOW_ID = "oidc/configuration";

    protected ConfigurationFlowTest() {
        super(FLOW_ID);
    }

    @Test
    public void test() throws ParseException, IOException {
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Response response = this.parseResponse(result);
        Assert.assertTrue((boolean)response.indicatesSuccess());
        FileSystemResource resource = new FileSystemResource("src/test/resources/conf/openid-configuration.json");
        OIDCProviderMetadata originalMetadata = OIDCProviderMetadata.parse((String)IOUtils.toString((InputStream)resource.getInputStream(), (String)"UTF-8"));
        Assert.assertNotNull((Object)originalMetadata.getIDTokenJWSAlgs());
        Assert.assertTrue((boolean)this.containsAll(originalMetadata.getIDTokenJWSAlgs(), Arrays.asList("RS256")));
        Assert.assertNull((Object)originalMetadata.getIDTokenJWEAlgs());
        Assert.assertNull((Object)originalMetadata.getIDTokenJWEEncs());
        Assert.assertNull((Object)originalMetadata.getUserInfoJWEAlgs());
        Assert.assertNull((Object)originalMetadata.getUserInfoJWEEncs());
        Assert.assertNull((Object)originalMetadata.getUserInfoJWSAlgs());
        OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((String)response.toHTTPResponse().getContent());
        Assert.assertEquals((Object)metadata.getIssuer(), (Object)new Issuer("https://op.example.org"));
        List<String> jweAlgs = Arrays.asList("RSA1_5", "RSA-OAEP", "RSA-OAEP-256", "A128KW", "A192KW", "A256KW", "A128GCMKW", "A192GCMKW", "A256GCMKW");
        List<String> jweEncs = Arrays.asList("A128CBC-HS256", "A192CBC-HS384", "A256CBC-HS512", "A128GCM", "A192GCM", "A256GCM");
        List<String> jwsAlgs = Arrays.asList("RS256", "RS384", "RS512", "ES256", "HS256", "HS384", "HS512");
        Assert.assertNotNull((Object)metadata.getIDTokenJWEAlgs());
        Assert.assertTrue((boolean)this.containsAll(metadata.getIDTokenJWEAlgs(), jweAlgs));
        Assert.assertNotNull((Object)metadata.getIDTokenJWEAlgs());
        Assert.assertTrue((boolean)this.containsAll(metadata.getIDTokenJWEEncs(), jweEncs));
        Assert.assertNotNull((Object)metadata.getIDTokenJWEEncs());
        Assert.assertTrue((boolean)this.containsAll(metadata.getIDTokenJWSAlgs(), jwsAlgs));
        Assert.assertNotNull((Object)metadata.getUserInfoJWEAlgs());
        Assert.assertTrue((boolean)this.containsAll(metadata.getUserInfoJWEAlgs(), jweAlgs));
        Assert.assertNotNull((Object)metadata.getUserInfoJWEAlgs());
        Assert.assertTrue((boolean)this.containsAll(metadata.getUserInfoJWEEncs(), jweEncs));
        Assert.assertNotNull((Object)metadata.getUserInfoJWEEncs());
        Assert.assertTrue((boolean)this.containsAll(metadata.getUserInfoJWSAlgs(), jwsAlgs));
    }

    protected boolean containsAll(Collection<? extends Algorithm> algs, Collection<String> strings) {
        ArrayList<String> algStrings = new ArrayList<String>();
        for (Algorithm algorithm : algs) {
            algStrings.add(algorithm.toString());
        }
        return strings.size() == algStrings.size() ? strings.containsAll(strings) : false;
    }
}

