/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.metadata.impl;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.shibboleth.idp.plugin.oidc.op.metadata.impl.CredentialMetadataValueResolver;
import net.shibboleth.idp.plugin.oidc.op.profile.spring.factory.BasicJWKCredentialFactoryBean;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.profile.config.OIDCProviderInformationConfiguration;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.mockito.Mockito;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CredentialMetadataValueResolverTest {
    protected RequestContext requestCtx;
    protected ProfileRequestContext profileRequestCtx;

    @BeforeMethod
    protected void setUpContext() throws ComponentInitializationException {
        this.requestCtx = new RequestContextBuilder().buildRequestContext();
        this.profileRequestCtx = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
    }

    protected CredentialMetadataValueResolver initResolver(String fileName) throws Exception {
        BasicJWKCredentialFactoryBean factory = new BasicJWKCredentialFactoryBean();
        factory.setResource((Resource)new FileSystemResource(new File(fileName)));
        factory.afterPropertiesSet();
        Credential credential = (Credential)factory.getObject();
        CredentialMetadataValueResolver resolver = new CredentialMetadataValueResolver();
        resolver.setId("mockId");
        resolver.initialize();
        RelyingPartyContext rpCtx = (RelyingPartyContext)this.profileRequestCtx.getSubcontext(RelyingPartyContext.class, true);
        OIDCProviderInformationConfiguration profileConfig = new OIDCProviderInformationConfiguration();
        SecurityConfiguration secConfig = new SecurityConfiguration();
        SignatureSigningConfiguration signConfig = (SignatureSigningConfiguration)Mockito.mock(SignatureSigningConfiguration.class);
        Mockito.when((Object)signConfig.getSigningCredentials()).thenReturn(Arrays.asList(credential));
        secConfig.setSignatureSigningConfiguration(signConfig);
        profileConfig.setSecurityConfiguration(secConfig);
        rpCtx.setProfileConfig((ProfileConfiguration)profileConfig);
        return resolver;
    }

    @Test
    public void testRsa() throws Exception {
        CredentialMetadataValueResolver resolver = this.initResolver("src/test/resources/net/shibboleth/idp/oidc/metadata/impl/idp-signing-rs256.jwk");
        Object result = resolver.resolveSingle(this.profileRequestCtx);
        Assert.assertNotNull((Object)result);
        System.out.println(result);
        Assert.assertTrue((boolean)(result instanceof List));
        Map json = (Map)((List)result).get(0);
        Assert.assertEquals((int)json.keySet().size(), (int)6);
        Assert.assertEquals(json.get("kty"), (Object)"RSA");
        Assert.assertEquals(json.get("n"), (Object)"pNf03ghVzMAw5sWrwDAMAZdSYNY2q7OVlxMInljMgz8XB5mf8XKH3EtP7AKrb8IAf7rGhfuH3T1N1C7F-jwIeYjXxMm2nIAZ0hXApgbccvBpf4n2H7IZflMjt4A3tt587QQSxQ069drCP4sYevxhTcLplJy6RWA0cLj-5CHyWy94zPeeA4GRd6xgHFLz0RNiSF0pF0kE4rmRgQVZ-b4_BmD9SsWnIpwhms5Ihciw36WyAGQUeZqULGsfwAMwlNLIaTCBLAoRgv370p-XsLrgz86pTkNBJqXP5GwI-ZfgiLmJuHjQ9l85KqHM87f-QdsqiV8KoRcslgXPqb6VOTJBVw");
        Assert.assertEquals(json.get("e"), (Object)"AQAB");
        Assert.assertEquals(json.get("alg"), (Object)"RS256");
        Assert.assertEquals(json.get("use"), (Object)"sig");
        Assert.assertEquals(json.get("kid"), (Object)"testkey");
    }
}

