/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import java.util.function.BiFunction;
import java.util.function.Function;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;

import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.utilities.java.support.logic.Constraint;

/**
 * A function that returns client_id via client information stored in {@link OIDCMetadataContext}.
 * 
 * @deprecated As of 3.1.0, moved to 
 * <code>net.shibboleth.oidc.profile.logic.ClientIDFromOIDCMetadataContextLookupFunction</code>
 */
@Deprecated(forRemoval = true, since = "3.1.0")
public class ClientIDFromOIDCMetadataContextLookupFunction
        implements BiFunction<ProfileRequestContext, JWTClaimsSet, String> {

    /** Strategy that will return {@link OIDCMetadataContext}. */
    @Nonnull private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy;

    /**
     * Constructor.
     */
    public ClientIDFromOIDCMetadataContextLookupFunction() {
        oidcMetadataContextLookupStrategy = new ChildContextLookup<>(OIDCMetadataContext.class).compose(
                new InboundMessageContextLookup());
    }

    /**
     * Set the strategy used to return the {@link OIDCMetadataContext}.
     * 
     * @param strategy The lookup strategy.
     */
    public void setOIDCMetadataContextLookupStrategy(
            @Nonnull final Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        oidcMetadataContextLookupStrategy =
                Constraint.isNotNull(strategy, "OIDCMetadataContext lookup strategy cannot be null");
    }

    /** {@inheritDoc} */
    @Override @Nullable
    public String apply(@Nonnull final ProfileRequestContext prc, @Nullable final JWTClaimsSet claimsSet) {
        final OIDCMetadataContext oidcMetadataContext = oidcMetadataContextLookupStrategy.apply(prc);
        if (oidcMetadataContext == null) {
            return null;
        }
        final OIDCClientInformation clientInformation = oidcMetadataContext.getClientInformation();
        if (clientInformation == null || clientInformation.getID() == null) {
            return null;
        }
        return clientInformation.getID().toString();
    }
    
}