/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientRegistrationRequest;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCRequestAction;
import net.shibboleth.idp.plugin.oidc.op.storage.RevocationCacheContexts;
import net.shibboleth.idp.plugin.oidc.op.token.support.RegistrationClaimsSet;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.storage.RevocationCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateRegistrationAccessToken
extends AbstractOIDCRequestAction<OIDCClientRegistrationRequest> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateRegistrationAccessToken.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientRegistrationTokenClaimsContext> registrationClaimsContextCreationStrategy = new ChildContextLookup(OIDCClientRegistrationTokenClaimsContext.class, true).compose((Function)new InboundMessageContextLookup());
    @NonnullAfterInit
    private DataSealer dataSealer;
    @NonnullAfterInit
    private RevocationCache revocationCache;
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @Nullable
    private RelyingPartyContext relyingPartyContext;
    @Nullable
    @NotEmpty
    private String accessToken;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setRegistrationClaimsContextCreationStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientRegistrationTokenClaimsContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.registrationClaimsContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationTokenClaimsContext creation strategy cannot be null");
    }

    public void setSealer(@Nonnull DataSealer sealer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"Data sealer cannot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    public void setRevocationCache(@Nonnull RevocationCache cache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.revocationCache = (RevocationCache)Constraint.isNotNull((Object)cache, (String)"RevocationCache cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.dataSealer == null) {
            throw new ComponentInitializationException("DataSealer cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("ObjectMapper cannot be null");
        }
        if (this.revocationCache == null) {
            throw new ComponentInitializationException("RevocationCache cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.relyingPartyContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (this.relyingPartyContext == null) {
            this.log.error("{} No relying party context found, invalid profile context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (((OIDCClientRegistrationRequest)this.getRequest()).getAccessToken() == null || ((OIDCClientRegistrationRequest)this.getRequest()).getAccessToken().getValue() == null) {
            this.log.debug("{} No access token in the request, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.accessToken = ((OIDCClientRegistrationRequest)this.getRequest()).getAccessToken().getValue();
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RegistrationClaimsSet claimsSet;
        try {
            String unwrapped = this.dataSealer.unwrap(this.accessToken);
            this.log.debug("{} Access token unwrapped into {}", (Object)this.getLogPrefix(), (Object)unwrapped);
            claimsSet = (RegistrationClaimsSet)this.objectMapper.readValue(unwrapped, RegistrationClaimsSet.class);
        }
        catch (JsonProcessingException | DataSealerException e) {
            this.log.error("{} Decoding access token failed: {}", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        this.log.debug("{} Registration access token decoded into {}", (Object)this.getLogPrefix(), (Object)claimsSet);
        if (Instant.now().isAfter(claimsSet.getExpiration())) {
            this.log.error("{} Registration access token exp is in the past {}", (Object)this.getLogPrefix(), (Object)claimsSet.getExpiration());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        if (this.revocationCache.isRevoked(RevocationCacheContexts.REGISTRATION_ACCESS_TOKEN, claimsSet.getJti())) {
            this.log.error("{} Registration access token {} has been revoked", (Object)this.getLogPrefix(), (Object)claimsSet.getJti());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        String relyingPartyId = claimsSet.getRelyingPartyId();
        if (relyingPartyId != null) {
            this.log.debug("{} Registration access token {} carries relying party identifier {}", new Object[]{this.getLogPrefix(), claimsSet.getJti(), relyingPartyId});
            this.relyingPartyContext.setVerified(Boolean.valueOf(true));
            this.relyingPartyContext.setRelyingPartyId(relyingPartyId);
        } else {
            this.log.debug("{} Registration access token {} carries no relying party identifier", (Object)this.getLogPrefix(), (Object)claimsSet.getJti());
        }
        this.log.debug("{} Registration access token {} successfully validated", (Object)this.getLogPrefix(), (Object)claimsSet.getJti());
        OIDCClientRegistrationTokenClaimsContext registrationClaimsContext = this.registrationClaimsContextCreationStrategy.apply(profileRequestContext);
        if (registrationClaimsContext == null) {
            this.log.error("{} Registration token claims context could not be created, invalid profile context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        registrationClaimsContext.setClaimsSet(claimsSet);
    }
}

