/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl;

import com.nimbusds.oauth2.sdk.Request;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOAuth2RequestDecoder<T extends Request>
extends AbstractHttpServletRequestMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseOAuth2RequestDecoder.class);
    @Nonnull
    private final Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE.OAUTH2");

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        T requestMessage = this.parseMessage();
        messageContext.setMessage(requestMessage);
        this.setMessageContext(messageContext);
        if (this.protocolMessageLog.isDebugEnabled()) {
            String message = this.getMessageToLog(requestMessage);
            if (message == null) {
                this.log.warn("Decoded protocol log message was null, nothing to log");
                return;
            }
            this.protocolMessageLog.debug(message);
        }
    }

    @Nonnull
    protected Logger getProtocolMessageLog() {
        return this.protocolMessageLog;
    }

    @Nullable
    protected abstract T parseMessage() throws MessageDecodingException;

    @Nullable
    protected abstract String getMessageToLog(T var1);
}

