/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.metadata.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.MetadataValueResolver;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmInfoMetadataValueResolver
extends AbstractIdentifiableInitializableComponent
implements MetadataValueResolver {
    private final Logger log = LoggerFactory.getLogger(AlgorithmInfoMetadataValueResolver.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    private boolean resolveEncryptionAlgs;
    private boolean resolveKeyTransportEncAlgs;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setResolveEncryptionAlgs(boolean flag) {
        this.resolveEncryptionAlgs = flag;
    }

    public void setResolveKeyTransportEncAlgs(boolean flag) {
        this.resolveKeyTransportEncAlgs = flag;
    }

    public Iterable<Object> resolve(ProfileRequestContext profileRequestContext) throws ResolverException {
        SignatureSigningConfiguration signingConfig;
        EncryptionConfiguration encryptionConfig;
        ArrayList<Object> result = new ArrayList<Object>();
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpCtx == null || rpCtx.getProfileConfig() == null) {
            this.log.warn("Could not find profile configuration, nothing to do");
            return result;
        }
        SecurityConfiguration securityConfig = rpCtx.getProfileConfig().getSecurityConfiguration(profileRequestContext);
        if (securityConfig == null) {
            this.log.warn("Could not find security configuration, nothing to do");
            return result;
        }
        List algorithms = this.resolveEncryptionAlgs ? ((encryptionConfig = securityConfig.getEncryptionConfiguration()) != null ? (this.resolveKeyTransportEncAlgs ? encryptionConfig.getKeyTransportEncryptionAlgorithms() : encryptionConfig.getDataEncryptionAlgorithms()) : new ArrayList()) : ((signingConfig = securityConfig.getSignatureSigningConfiguration()) != null ? signingConfig.getSignatureAlgorithms() : new ArrayList());
        result.add(algorithms);
        return result;
    }

    public Object resolveSingle(@Nullable ProfileRequestContext profileRequestContext) throws ResolverException {
        Iterator<Object> iterator = this.resolve(profileRequestContext).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

