/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.ValidatePKCE;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.profile.config.OIDCAuthorizationConfiguration;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidatePKCETest
extends BaseOIDCResponseActionTest {
    private ValidatePKCE action;
    private String codeVerifier = "1234567812345678123456781234567812345678123456781234567812345678";

    @BeforeMethod
    private void init() throws ComponentInitializationException, URISyntaxException, ParseException {
        this.action = new ValidatePKCE();
        this.action.initialize();
        TokenRequest req = new TokenRequest(new URI("https://client.com/callback"), new ClientID(this.clientId), (AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode("mockCode"), new URI("https://client.com/callback"), new CodeVerifier(this.codeVerifier)));
        this.setTokenRequest(req);
        AuthorizeCodeClaimsSet claims = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setACR(new ACR("0")).setCodeChallenge("S256" + CodeChallenge.compute((CodeChallengeMethod)CodeChallengeMethod.S256, (CodeVerifier)new CodeVerifier(this.codeVerifier)).getValue()).build();
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claims);
    }

    @Test
    public void testSuccess() {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testWrongValue() throws URISyntaxException {
        TokenRequest req = new TokenRequest(new URI("https://client.com/callback"), new ClientID(this.clientId), (AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode("mockCode"), new URI("https://client.com/callback"), new CodeVerifier(this.codeVerifier + "someWrongValue")));
        this.setTokenRequest(req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"MessageAuthenticationError");
    }

    @Test
    public void testFailPlainNotAllowed() throws URISyntaxException {
        AuthorizeCodeClaimsSet claims = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setACR(new ACR("0")).setCodeChallenge("plain" + CodeChallenge.compute((CodeChallengeMethod)CodeChallengeMethod.PLAIN, (CodeVerifier)new CodeVerifier(this.codeVerifier)).getValue()).build();
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessage");
    }

    @Test
    public void testSuccessPlain() throws URISyntaxException {
        ((OIDCAuthorizationConfiguration)this.rpCtx.getProfileConfig()).setAllowPKCEPlain(true);
        AuthorizeCodeClaimsSet claims = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setACR(new ACR("0")).setCodeChallenge("plain" + CodeChallenge.compute((CodeChallengeMethod)CodeChallengeMethod.PLAIN, (CodeVerifier)new CodeVerifier(this.codeVerifier)).getValue()).build();
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testFailPlain() throws URISyntaxException {
        ((OIDCAuthorizationConfiguration)this.rpCtx.getProfileConfig()).setAllowPKCEPlain(true);
        AuthorizeCodeClaimsSet claims = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setACR(new ACR("0")).setCodeChallenge("plain" + CodeChallenge.compute((CodeChallengeMethod)CodeChallengeMethod.PLAIN, (CodeVerifier)new CodeVerifier(this.codeVerifier + "someWrongvalue")).getValue()).build();
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"MessageAuthenticationError");
    }

    @Test
    public void testSuccessNoPKCE() throws URISyntaxException {
        TokenRequest req = new TokenRequest(new URI("https://client.com/callback"), new ClientID(this.clientId), (AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode("mockCode"), new URI("https://client.com/callback")));
        this.setTokenRequest(req);
        AuthorizeCodeClaimsSet claims = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setACR(new ACR("0")).build();
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testFailureNoPKCE() throws URISyntaxException {
        ((OIDCAuthorizationConfiguration)this.rpCtx.getProfileConfig()).setForcePKCE(true);
        TokenRequest req = new TokenRequest(new URI("https://client.com/callback"), new ClientID(this.clientId), (AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode("mockCode"), new URI("https://client.com/callback")));
        this.setTokenRequest(req);
        AuthorizeCodeClaimsSet claims = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setACR(new ACR("0")).build();
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessage");
    }

    @Test
    public void testFailureTokenRequestMissingVerfier() throws URISyntaxException {
        TokenRequest req = new TokenRequest(new URI("https://client.com/callback"), new ClientID(this.clientId), (AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode("mockCode"), new URI("https://client.com/callback")));
        this.setTokenRequest(req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessage");
    }

    @Test
    public void testSuccessNoAuthzCode() throws URISyntaxException {
        ((OIDCAuthorizationConfiguration)this.rpCtx.getProfileConfig()).setForcePKCE(true);
        TokenRequest req = new TokenRequest(new URI("https://client.com/callback"), new ClientID(this.clientId), (AuthorizationGrant)new RefreshTokenGrant(new RefreshToken()));
        this.setTokenRequest(req);
        RefreshTokenClaimsSet claims = new RefreshTokenClaimsSet.Builder(new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setACR(new ACR("0")).build(), Instant.now(), Instant.now()).build();
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testFailUnknownType() throws URISyntaxException {
        AuthorizeCodeClaimsSet claims = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setACR(new ACR("0")).setCodeChallenge("not_S256" + CodeChallenge.compute((CodeChallengeMethod)CodeChallengeMethod.S256, (CodeVerifier)new CodeVerifier(this.codeVerifier)).getValue()).build();
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessage");
    }
}

