/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.function.Function;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.TokenRequestRequestedClaimsLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.SetRequestedClaimsToResponseContext;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.test.service.MockReloadableService;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SetRequestedClaimsToResponseContextTest
extends BaseOIDCResponseActionTest {
    private SetRequestedClaimsToResponseContext action;

    private void init() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, ParseException {
        this.respCtx.setScope(new Scope());
        AuthorizeCodeClaimsSet claims = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject(this.subject).setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setACR(new ACR("0")).setClaimsRequest(OIDCClaimsRequest.parse((String)"{\"id_token\":{\"email\":{\"essential\":true}},\"userinfo\":{\"name\":{\"essential\":true}}}")).build();
        this.respCtx.setSubject("subject");
        this.respCtx.setAuthTime(Instant.now());
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claims);
        this.respCtx.setAcr("0");
        this.respCtx.setRedirectURI(new URI("http://example.com"));
        this.action = new SetRequestedClaimsToResponseContext();
        this.action.setTranscoderRegistry((ReloadableService)new MockReloadableService(null));
        this.action.setRequestedClaimsLookupStrategy((Function)new TokenRequestRequestedClaimsLookupFunction());
        this.action.initialize();
        SubjectContext subjectCtx = (SubjectContext)this.profileRequestCtx.getSubcontext(SubjectContext.class, true);
        subjectCtx.setPrincipalName("userPrin");
    }

    @Test
    public void testTokenClaimsRemainsTheSame() throws NoSuchAlgorithmException, ParseException, ComponentInitializationException, URISyntaxException {
        this.init();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        JSONObject claims = (JSONObject)this.respCtx.getAuthorizationGrantClaimsSet().getClaimsSet().getClaim("claims");
        Assert.assertTrue((boolean)this.isEssential(claims, "id_token", "email"));
        Assert.assertTrue((boolean)this.isEssential(claims, "userinfo", "name"));
    }

    private boolean isEssential(JSONObject source, String parentClaim, String claim) {
        JSONObject parent = (JSONObject)source.get((Object)parentClaim);
        Assert.assertNotNull((Object)parent);
        JSONObject value = (JSONObject)parent.get((Object)claim);
        Assert.assertNotNull((Object)value);
        Object essential = value.get((Object)"essential");
        Assert.assertNotNull((Object)essential);
        return (Boolean)essential;
    }
}

