/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseConsentContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.SetAuthorizationCodeToResponseContext;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SetAuthorizationCodeToResponseContextTest
extends BaseOIDCResponseActionTest {
    private SetAuthorizationCodeToResponseContext action;

    private void init() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException {
        this.init(null);
    }

    private void init(Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> manipulationStrategy) throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException {
        this.respCtx.setScope(new Scope());
        this.respCtx.setSubject("subject");
        this.respCtx.setAuthTime(Instant.now());
        this.respCtx.setAcr("0");
        this.respCtx.setRedirectURI(new URI("http://example.com"));
        this.action = new SetAuthorizationCodeToResponseContext();
        this.action.setDataSealer(this.getDataSealer());
        if (manipulationStrategy != null) {
            this.action.setTokenClaimsSetManipulationStrategyLookupStrategy(manipulationStrategy);
        }
        this.action.initialize();
        SubjectContext subjectCtx = (SubjectContext)this.profileRequestCtx.getSubcontext(SubjectContext.class, true);
        subjectCtx.setPrincipalName("userPrin");
    }

    @Test
    public void testSuccess() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, java.text.ParseException, DataSealerException {
        this.init();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getAuthorizationCode());
        AuthorizeCodeClaimsSet ac = AuthorizeCodeClaimsSet.parse((String)this.respCtx.getAuthorizationCode().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertNotNull((Object)ac);
    }

    @Test
    public void testSuccessWithCustomClaim() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, java.text.ParseException, DataSealerException {
        this.init(prc -> (prc2, map) -> SetAuthorizationCodeToResponseContextTest.addEntryToMap(map, "custom_claim", "custom_value"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getAuthorizationCode());
        AuthorizeCodeClaimsSet ac = AuthorizeCodeClaimsSet.parse((String)this.respCtx.getAuthorizationCode().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertNotNull((Object)ac);
        Assert.assertNotNull((Object)ac.getClaimsSet().getClaim("custom_claim"));
        Assert.assertEquals((String)ac.getClaimsSet().getStringClaim("custom_claim"), (String)"custom_value");
    }

    @Test
    public void testSuccessConsent() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, java.text.ParseException, DataSealerException {
        this.init();
        OIDCAuthenticationResponseConsentContext consCtx = (OIDCAuthenticationResponseConsentContext)this.respCtx.addSubcontext((BaseContext)new OIDCAuthenticationResponseConsentContext());
        consCtx.getConsentedAttributes().add((Object)"3");
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getAuthorizationCode());
        AuthorizeCodeClaimsSet ac = AuthorizeCodeClaimsSet.parse((String)this.respCtx.getAuthorizationCode().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertNotNull((Object)ac);
        Assert.assertEquals((Collection)ac.getConsentedClaims(), (Collection)consCtx.getConsentedAttributes());
    }

    @Test
    public void testSuccessWithTokenDelivery() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, java.text.ParseException, DataSealerException {
        this.init();
        OIDCAuthenticationResponseTokenClaimsContext tokenCtx = (OIDCAuthenticationResponseTokenClaimsContext)this.respCtx.addSubcontext((BaseContext)new OIDCAuthenticationResponseTokenClaimsContext());
        tokenCtx.getClaims().setClaim("1", (Object)"1");
        tokenCtx.getIdtokenClaims().setClaim("2", (Object)"2");
        tokenCtx.getUserinfoClaims().setClaim("3", (Object)"3");
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getAuthorizationCode());
        AuthorizeCodeClaimsSet ac = AuthorizeCodeClaimsSet.parse((String)this.respCtx.getAuthorizationCode().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertNotNull((Object)ac);
        Assert.assertNotNull((Object)ac.getDeliveryClaims().getClaim("1"));
        Assert.assertNotNull((Object)ac.getIDTokenDeliveryClaims().getClaim("2"));
        Assert.assertNotNull((Object)ac.getUserinfoDeliveryClaims().getClaim("3"));
    }

    @Test
    public void testSuccessPKCE() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, java.text.ParseException, DataSealerException, ParseException {
        this.init();
        this.request = AuthenticationRequest.parse((String)"code_challenge=123456&code_challenge_method=S256&response_type=id_token+token&client_id=s6BhdRkqt3&login_hint=foo&redirect_uri=https%3A%2F%2Fclient.example.org%2Fcb&scope=openid%20email%20profile%20offline_access&state=af0ifjsldkj&nonce=n-0S6_WzA2Mj");
        this.setAuthenticationRequest(this.request);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getAuthorizationCode());
        AuthorizeCodeClaimsSet ac = AuthorizeCodeClaimsSet.parse((String)this.respCtx.getAuthorizationCode().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertNotNull((Object)ac);
        Assert.assertEquals((String)ac.getCodeChallenge(), (String)"S256123456");
    }

    @Test
    public void testSuccessPKCEDefault() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, java.text.ParseException, DataSealerException, ParseException {
        this.init();
        this.request = AuthenticationRequest.parse((String)"code_challenge=123456&response_type=id_token+token&client_id=s6BhdRkqt3&login_hint=foo&redirect_uri=https%3A%2F%2Fclient.example.org%2Fcb&scope=openid%20email%20profile%20offline_access&state=af0ifjsldkj&nonce=n-0S6_WzA2Mj");
        this.setAuthenticationRequest(this.request);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getAuthorizationCode());
        AuthorizeCodeClaimsSet ac = AuthorizeCodeClaimsSet.parse((String)this.respCtx.getAuthorizationCode().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertNotNull((Object)ac);
        Assert.assertEquals((String)ac.getCodeChallenge(), (String)"plain123456");
    }

    @Test
    public void testFailNoRPCtx() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        this.init();
        this.profileRequestCtx.removeSubcontext(RelyingPartyContext.class);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileConfiguration");
    }

    @Test
    public void testFailNoSubjectCtx() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        this.init();
        this.profileRequestCtx.removeSubcontext(SubjectContext.class);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
    }

    @Test
    public void testFailNoProfileConf() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        this.init();
        RelyingPartyContext rpCtx = (RelyingPartyContext)this.profileRequestCtx.getSubcontext(RelyingPartyContext.class, false);
        rpCtx.setProfileConfig(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileConfiguration");
    }
}

