/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import net.shibboleth.idp.consent.context.ConsentManagementContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.RevokeConsent;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RevokeConsentTest
extends BaseOIDCResponseActionTest {
    private RevokeConsent action;

    @BeforeMethod
    private void init() throws ComponentInitializationException {
        this.action = new RevokeConsent();
        this.action.initialize();
        this.respCtx.setScope(new Scope());
    }

    @Test
    public void testNotRevoked() throws NoSuchAlgorithmException, ComponentInitializationException {
        this.action.execute(this.requestCtx);
        Assert.assertNull((Object)this.profileRequestCtx.getSubcontext(ConsentManagementContext.class));
    }

    @Test
    public void testRevokeOfflineAccess() throws NoSuchAlgorithmException, ComponentInitializationException {
        Scope scope = new Scope();
        scope.add((Object)OIDCScopeValue.OFFLINE_ACCESS);
        this.respCtx.setScope(scope);
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.requestCtx));
        Assert.assertTrue((boolean)((ConsentManagementContext)this.profileRequestCtx.getSubcontext(ConsentManagementContext.class)).getRevokeConsent());
    }

    @Test
    public void testNoRevocationCache() throws NoSuchAlgorithmException, ComponentInitializationException {
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).prompt(new Prompt(new String[]{"consent"})).state(new State()).build();
        this.setAuthenticationRequest(req);
        this.action.initialize();
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.requestCtx));
        Assert.assertTrue((boolean)((ConsentManagementContext)this.profileRequestCtx.getSubcontext(ConsentManagementContext.class)).getRevokeConsent());
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullStrategy() throws NoSuchAlgorithmException, ComponentInitializationException {
        this.action = new RevokeConsent();
        this.action.setPromptLookupStrategy(null);
    }
}

