/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.util.Date;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.InitializeRelyingPartyContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class InitializeRelyingPartyContextTest {
    private InitializeRelyingPartyContext action;
    private RequestContext requestCtx;
    private ProfileRequestContext prc;
    private OIDCMetadataContext metadataCtx;

    @BeforeMethod
    public void init() throws ComponentInitializationException {
        this.action = new InitializeRelyingPartyContext();
        this.action.initialize();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).state(new State()).build();
        this.requestCtx = new RequestContextBuilder().setInboundMessage((Object)req).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        this.metadataCtx = (OIDCMetadataContext)this.prc.getInboundMessageContext().addSubcontext((BaseContext)new OIDCMetadataContext());
        OIDCClientInformation information = new OIDCClientInformation(new ClientID("000123"), new Date(), new OIDCClientMetadata(), new Secret());
        this.metadataCtx.setClientInformation(information);
    }

    @Test
    public void testSuccessVerified() {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getRelyingPartyId(), (String)"000123");
        Assert.assertTrue((boolean)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).isVerified());
    }

    @Test
    public void testSuccessUnverified() {
        this.metadataCtx.setClientInformation(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getRelyingPartyId(), (String)"000123");
        Assert.assertFalse((boolean)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).isVerified());
    }

    @Test
    public void testSuccessUnverifiedNoMetadata() {
        this.prc.getInboundMessageContext().removeSubcontext(OIDCMetadataContext.class);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getRelyingPartyId(), (String)"000123");
        Assert.assertFalse((boolean)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).isVerified());
    }

    @Test
    public void testSuccessNoRequest() throws ComponentInitializationException {
        this.requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testFailsNullOidcMetadataContextLookupStrategy() {
        this.action = new InitializeRelyingPartyContext();
        this.action.setOidcMetadataContextLookupStrategy(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testFailsNullClientIDLookupStrategy() {
        this.action = new InitializeRelyingPartyContext();
        this.action.setClientIDLookupStrategy(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testFailsNullRelyingPartyContextCreationStrategy() {
        this.action = new InitializeRelyingPartyContext();
        this.action.setRelyingPartyContextCreationStrategy(null);
    }
}

