/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.function.Function;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.EncryptProcessedToken;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.security.credential.BasicJWKCredential;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.EncryptionParameters;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EncryptProcessedTokenTest {
    private ProfileRequestContext prc;
    private EncryptProcessedToken action;
    private RequestContext requestCtx;
    private OIDCMetadataContext oidcCtx;
    private OIDCAuthenticationResponseContext oidcRespCtx;
    private KeyPair kp;
    private EncryptionContext encCtx;

    @BeforeMethod
    public void setup() throws ComponentInitializationException, NoSuchAlgorithmException, JOSEException {
        this.requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).state(new State()).build();
        this.prc.getInboundMessageContext().setMessage((Object)req);
        this.oidcCtx = (OIDCMetadataContext)this.prc.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class, true);
        this.oidcRespCtx = new OIDCAuthenticationResponseContext();
        this.prc.getOutboundMessageContext().addSubcontext((BaseContext)this.oidcRespCtx);
        OIDCClientMetadata metaData = new OIDCClientMetadata();
        OIDCClientInformation information = new OIDCClientInformation(new ClientID("test"), null, metaData, new Secret("ultimatetopsecretultimatetopsecret"), null, null);
        this.oidcCtx.setClientInformation(information);
        BaseContext ctx = this.prc.getSubcontext(RelyingPartyContext.class, true);
        this.encCtx = (EncryptionContext)ctx.getSubcontext(EncryptionContext.class, true);
        EncryptionParameters params = new EncryptionParameters();
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        this.kp = kpg.generateKeyPair();
        BasicJWKCredential credentialRSA = new BasicJWKCredential();
        credentialRSA.setPublicKey(this.kp.getPublic());
        credentialRSA.setKid("myKid");
        params.setKeyTransportEncryptionCredential((Credential)credentialRSA);
        params.setKeyTransportEncryptionAlgorithm("RSA-OAEP-256");
        params.setDataEncryptionAlgorithm("A128CBC-HS256");
        this.encCtx.setAssertionEncryptionParameters(params);
        RSASSASigner signer = new RSASSASigner(this.kp.getPrivate());
        SignedJWT signed = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), new JWTClaimsSet.Builder().subject("alice").build());
        signed.sign((JWSSigner)signer);
        this.oidcRespCtx.setProcessedToken((JWT)signed);
        this.action = new EncryptProcessedToken();
        this.action.initialize();
    }

    @Test
    public void testSuccess() {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertTrue((boolean)(this.oidcRespCtx.getProcessedToken() instanceof EncryptedJWT));
        EncryptedJWT jwe = (EncryptedJWT)this.oidcRespCtx.getProcessedToken();
        Assert.assertEquals((String)"myKid", (String)jwe.getHeader().getKeyID());
    }

    @Test
    public void testSuccessUserInfo() {
        this.oidcRespCtx.setProcessedToken(null);
        JSONObject info = new JSONObject();
        info.put((Object)"sub", (Object)"alice");
        this.oidcRespCtx.setUserInfo(new UserInfo(info));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertTrue((boolean)(this.oidcRespCtx.getProcessedToken() instanceof EncryptedJWT));
    }

    @Test
    public void testSuccessEC() throws NoSuchAlgorithmException {
        EncryptionParameters params = new EncryptionParameters();
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
        kpg.initialize(256);
        this.kp = kpg.generateKeyPair();
        BasicJWKCredential credentialEC = new BasicJWKCredential();
        credentialEC.setPublicKey(this.kp.getPublic());
        params.setKeyTransportEncryptionCredential((Credential)credentialEC);
        params.setKeyTransportEncryptionAlgorithm("ECDH-ES");
        params.setDataEncryptionAlgorithm("A128CBC-HS256");
        this.encCtx.setAssertionEncryptionParameters(params);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertTrue((boolean)(this.oidcRespCtx.getProcessedToken() instanceof EncryptedJWT));
    }

    @Test
    public void testNoInput() {
        this.oidcRespCtx.setProcessedToken(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testFailNoEncryptionContext() {
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class, false)).removeSubcontext(EncryptionContext.class);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
    }

    @Test
    public void testSuccessNoEnc() throws ParseException {
        ((EncryptionContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class, false)).getSubcontext(EncryptionContext.class, false)).setAssertionEncryptionParameters(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)"alice", (String)this.oidcRespCtx.getProcessedToken().getJWTClaimsSet().getSubject());
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testInitializationFail() {
        this.action.setEncryptionContextLookupStrategy(new ChildContextLookup(EncryptionContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class)));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testInitializationFail2() {
        this.action = new EncryptProcessedToken();
        this.action.setEncryptionContextLookupStrategy(null);
    }
}

