/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.Arrays;
import java.util.List;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddRequestObjectSecurityConfigurationToClientMetadata;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddSecurityConfigurationToClientMetadataTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCClientMetadataPopulationTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddRequestObjectSecurityConfigurationToClientMetadataTest
extends BaseOIDCClientMetadataPopulationTest {
    AddRequestObjectSecurityConfigurationToClientMetadata action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new AddRequestObjectSecurityConfigurationToClientMetadata();
        this.action.initialize();
    }

    protected AddRequestObjectSecurityConfigurationToClientMetadata constructAction() {
        return new AddRequestObjectSecurityConfigurationToClientMetadata();
    }

    protected void setUpContext(OIDCClientMetadata input, OIDCClientMetadata output, List<String> signingAlgs, List<String> encryptionAlgs, List<String> encryptionEncs) throws ComponentInitializationException {
        super.setUpContext(input, output);
        AddSecurityConfigurationToClientMetadataTest.initializeRpCtx(this.profileRequestCtx, signingAlgs, encryptionAlgs, encryptionEncs);
    }

    @Test
    public void testEmptySignatureAlgorithmsListWithoutRequest() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertNull((Object)output.getRequestObjectJWSAlg());
    }

    @Test
    public void testSignatureAlgorithmsListWithRS256Request() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setRequestObjectJWSAlg(JWSAlgorithm.RS256);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Arrays.asList("RS256"), null, null);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Object)output.getRequestObjectJWSAlg(), (Object)JWSAlgorithm.RS256);
    }

    @Test
    public void testSignatureAlgorithmsListWithES512Request() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setRequestObjectJWSAlg(JWSAlgorithm.ES512);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Arrays.asList("RS256", "ES512"), null, null);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Object)output.getRequestObjectJWSAlg(), (Object)JWSAlgorithm.ES512);
    }

    @Test
    public void testInvalidEncryptionConfig() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setRequestObjectJWEAlg(null);
        input.setRequestObjectJWEEnc(EncryptionMethod.A128CBC_HS256);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Arrays.asList("RS256"), null, null);
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidMessage");
    }

    @Test
    public void testUnsupportedKeyTransportEncryptionConfig() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setRequestObjectJWEAlg(new JWEAlgorithm("RSA1_5"));
        input.setRequestObjectJWEEnc(EncryptionMethod.A256CBC_HS512);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Arrays.asList("RS256"), Arrays.asList("RSA1_5"), Arrays.asList("A128CBC-HS256"));
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidMessage");
    }

    @Test
    public void testUnsupportedEncryptionConfig() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setRequestObjectJWEAlg(new JWEAlgorithm("A128GCMKW"));
        input.setRequestObjectJWEEnc(EncryptionMethod.A128CBC_HS256);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Arrays.asList("RS256"), Arrays.asList("RSA1_5"), Arrays.asList("A128CBC-HS256"));
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidMessage");
    }

    @Test
    public void testValidEncryptionConfig() throws ComponentInitializationException {
        OIDCClientMetadata input = new OIDCClientMetadata();
        input.setRequestObjectJWEAlg(new JWEAlgorithm("RSA1_5"));
        input.setRequestObjectJWEEnc(EncryptionMethod.A128CBC_HS256);
        OIDCClientMetadata output = new OIDCClientMetadata();
        this.setUpContext(input, output, Arrays.asList("RS256"), Arrays.asList("RSA1_5"), Arrays.asList("A128CBC-HS256"));
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        Assert.assertEquals((Object)output.getRequestObjectJWEAlg(), (Object)new JWEAlgorithm("RSA1_5"));
        Assert.assertEquals((Object)output.getRequestObjectJWEEnc(), (Object)EncryptionMethod.A128CBC_HS256);
    }
}

