/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.flow;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.profile.flow.AbstractOidcFlowTest;
import org.opensaml.storage.StorageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RegistrationManagementFlowTest
extends AbstractOidcFlowTest {
    @Nonnull
    public static final String FLOW_ID = "admin/oidc/clients";
    @Autowired
    @Qualifier(value="shibboleth.StorageService")
    StorageService storageService;
    String clientId;

    public RegistrationManagementFlowTest() {
        super(FLOW_ID, "end");
    }

    @BeforeMethod
    public void setUp() {
        this.clientId = null;
    }

    @AfterMethod
    public void tearDown() throws IOException {
        if (this.clientId != null) {
            this.storageService.delete("oidcClientInformation", this.clientId);
        }
    }

    @Test
    public void testNoRequiredParameters() throws Exception {
        this.request.setMethod("GET");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"end");
        Assert.assertEquals((int)this.response.getStatus(), (int)404);
    }

    @Test
    public void testFetchingExistingClient() throws Exception {
        this.clientId = "mockClientId";
        this.storageService.create("oidcClientInformation", this.clientId, this.sampleRecord(), null);
        Assert.assertTrue((boolean)this.recordExists(this.clientId));
        this.request.setMethod("GET");
        this.request.addParameter("client_id", this.clientId);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"end");
        this.assertClientInfoFromResponse();
        Assert.assertTrue((boolean)this.recordExists(this.clientId));
    }

    @Test
    public void testDeletingExistingClient() throws Exception {
        this.clientId = "mockClientId";
        this.storageService.create("oidcClientInformation", this.clientId, this.sampleRecord(), null);
        Assert.assertTrue((boolean)this.recordExists(this.clientId));
        this.request.setMethod("DELETE");
        this.request.addParameter("client_id", this.clientId);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"end");
        Assert.assertEquals((int)this.response.getStatus(), (int)204);
        Assert.assertFalse((boolean)this.recordExists(this.clientId));
    }

    @Test
    public void testFetchinggNonExistingClient() throws Exception {
        this.clientId = "mockClientId";
        Assert.assertFalse((boolean)this.recordExists(this.clientId));
        this.request.setMethod("GET");
        this.request.addParameter("client_id", this.clientId);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        Assert.assertEquals((String)result.getOutcome().getId(), (String)"end");
        Assert.assertEquals((int)this.response.getStatus(), (int)404);
        Assert.assertFalse((boolean)this.recordExists(this.clientId));
    }

    protected void assertClientInfoFromResponse() throws Exception {
        Map map = (Map)new ObjectMapper().readValue(this.response.getContentAsString(), Map.class);
        OIDCClientInformation clientInfo = OIDCClientInformation.parse((JSONObject)new JSONObject(map));
        Assert.assertEquals((Object)clientInfo.getID(), (Object)new ClientID(this.clientId));
        Assert.assertEquals((String)clientInfo.getSecret().getValue(), (String)"testSecret1234");
        OIDCClientMetadata metadata = clientInfo.getOIDCMetadata();
        Assert.assertEquals((int)metadata.getScope().size(), (int)2);
        Assert.assertTrue((boolean)metadata.getScope().contains("openid"));
        Assert.assertTrue((boolean)metadata.getScope().contains("profile"));
        Assert.assertEquals((Object)metadata.getRedirectionURI(), (Object)new URI("https://example.org/redirect_uri"));
        Assert.assertEquals((int)metadata.getResponseTypes().size(), (int)1);
        Assert.assertEquals((Set)((Set)metadata.getResponseTypes().iterator().next()), (Set)ResponseType.CODE);
        Assert.assertEquals((int)metadata.getGrantTypes().size(), (int)1);
        Assert.assertEquals(metadata.getGrantTypes().iterator().next(), (Object)GrantType.AUTHORIZATION_CODE);
    }

    protected boolean recordExists(String clientId) throws Exception {
        return this.storageService.read("oidcClientInformation", clientId) != null;
    }

    private String sampleRecord() {
        return "  {\n    \"scope\":\"openid profile\",\n    \"redirect_uris\":[\"https://example.org/redirect_uri\"],\n    \"client_id\":\"mockClientId\",\n    \"client_secret\":\"testSecret1234\",\n    \"response_types\":[\"code\"],\n    \"grant_types\":[\"authorization_code\"]\n}";
    }
}

