/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.flow;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jasminb.jsonapi.models.errors.Error;
import com.github.jasminb.jsonapi.models.errors.Errors;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.flow.AbstractOidcFlowTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.token.support.RegistrationClaimsSet;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.utilities.java.support.security.DataSealer;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IssueRegistrationAccessTokenFlowTest
extends AbstractOidcFlowTest {
    @Nonnull
    public static final String FLOW_ID = "admin/oidc/issue-registration-access-token";

    public IssueRegistrationAccessTokenFlowTest() {
        super(FLOW_ID);
    }

    @Test
    public void testWithNoParameters() throws Exception {
        this.buildRequest(null, null, null, null, null);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"CommitResponse");
        this.assertErrorResponse(400, "Invalid Request");
    }

    @Test
    public void testWithInvalidLocation() throws Exception {
        this.buildRequest("P1D", "src/test/not_existing", "mockRpId", null, null);
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((String)outcome.getId(), (String)"CommitResponse");
        this.assertErrorResponse(400, "Invalid Request");
    }

    @Test
    public void testWithValidPolicyLocationAndId() throws Exception {
        this.buildRequest("P1D", "src/test/resources/conf/metadata-policy1.json", "mockRpId", null, null);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((int)this.response.getStatus(), (int)200);
        Assert.assertEquals((String)outcome.getId(), (String)"CommitResponse");
        this.validateToken(this.parseSuccessResponse(result, AccessTokenResponse.class), "mockRpId", null, this.buildMetadataPolicy1());
    }

    @Test
    public void testWithPolicyLocationOnly() throws Exception {
        this.buildRequest("P1D", "src/test/resources/conf/metadata-policy1.json", null, null, null);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((int)this.response.getStatus(), (int)200);
        Assert.assertEquals((String)outcome.getId(), (String)"CommitResponse");
        this.validateToken(this.parseSuccessResponse(result, AccessTokenResponse.class), null, null, this.buildMetadataPolicy1());
    }

    @Test
    public void testWithPolicyIdOnly() throws Exception {
        this.buildRequest("P1D", null, "mockRpId", null, null);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((int)this.response.getStatus(), (int)200);
        Assert.assertEquals((String)outcome.getId(), (String)"CommitResponse");
        this.validateToken(this.parseSuccessResponse(result, AccessTokenResponse.class), "mockRpId", null, null);
    }

    @Test
    public void testWithPolicyIdClientId() throws Exception {
        this.buildRequest("P1D", null, "mockRpId", "mockClientId", null);
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((int)this.response.getStatus(), (int)200);
        Assert.assertEquals((String)outcome.getId(), (String)"CommitResponse");
        this.validateToken(this.parseSuccessResponse(result, AccessTokenResponse.class), "mockRpId", "mockClientId", null);
    }

    @Test
    public void testWithPolicyIdReplacementIgnoredWithoutClientId() throws Exception {
        this.buildRequest("P1D", null, "mockRpId", null, "true");
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((int)this.response.getStatus(), (int)200);
        Assert.assertEquals((String)outcome.getId(), (String)"CommitResponse");
        RegistrationClaimsSet claimsSet = this.validateToken(this.parseSuccessResponse(result, AccessTokenResponse.class), "mockRpId", null, null);
        Assert.assertFalse((boolean)claimsSet.isReplacement());
    }

    @Test
    public void testWithPolicyIdReplacemenSetWithClientId() throws Exception {
        this.buildRequest("P1D", null, "mockRpId", "mockClientId", "true");
        this.initializeThreadLocals();
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        FlowExecutionOutcome outcome = result.getOutcome();
        Assert.assertEquals((int)this.response.getStatus(), (int)200);
        Assert.assertEquals((String)outcome.getId(), (String)"CommitResponse");
        RegistrationClaimsSet claimsSet = this.validateToken(this.parseSuccessResponse(result, AccessTokenResponse.class), "mockRpId", "mockClientId", null);
        Assert.assertTrue((boolean)claimsSet.isReplacement());
    }

    protected RegistrationClaimsSet validateToken(AccessTokenResponse tokenResponse, String policyId, String clientId, Map<String, MetadataPolicy> policy) throws Exception {
        Assert.assertNotNull((Object)tokenResponse.getTokens());
        BearerAccessToken accessToken = tokenResponse.getTokens().getBearerAccessToken();
        Assert.assertNotNull((Object)accessToken);
        DataSealer dataSealer = BaseOIDCResponseActionTest.initializeDataSealer();
        String decryptedToken = dataSealer.unwrap(accessToken.getValue());
        RegistrationClaimsSet claimsSet = (RegistrationClaimsSet)new ObjectMapper().readValue(decryptedToken, RegistrationClaimsSet.class);
        Assert.assertEquals((String)claimsSet.getKeyType(), (String)"rt");
        Assert.assertNotNull((Object)claimsSet.getJti());
        Assert.assertEquals((String)claimsSet.getIssuer(), (String)"https://op.example.org");
        Assert.assertEquals((String)claimsSet.getRelyingPartyId(), (String)policyId);
        Assert.assertEquals((String)claimsSet.getClientId(), (String)clientId);
        if (policy != null) {
            Map tokenPolicy = claimsSet.getMetadata();
            Assert.assertNotNull((Object)tokenPolicy);
            Assert.assertEquals((int)tokenPolicy.size(), (int)policy.size());
            for (String claim : tokenPolicy.keySet()) {
                Assert.assertEquals((String)((MetadataPolicy)tokenPolicy.get(claim)).toString(), (String)policy.get(claim).toString());
            }
        } else {
            Assert.assertNull((Object)claimsSet.getMetadata());
        }
        return claimsSet;
    }

    private Map<String, MetadataPolicy> buildMetadataPolicy1() {
        HashMap<String, MetadataPolicy> policies = new HashMap<String, MetadataPolicy>();
        policies.put("grant_types", new MetadataPolicy.Builder().withOneOfValues(List.of("authorization_code", "implicit")).build());
        policies.put("client_name", new MetadataPolicy.Builder().withDefaultValue((Object)"A known test application").build());
        policies.put("organization_name", new MetadataPolicy.Builder().withValue((Object)"A trusted organization").build());
        policies.put("redirect_uris", new MetadataPolicy.Builder().withRegexp("^https:\\/\\/(?:([^.]+).)?example.org\\/(.*)").withEssential(Boolean.valueOf(true)).build());
        policies.put("id_token_signed_response_alg", new MetadataPolicy.Builder().withSubsetOfValues(List.of("RS256", "RS384", "RS512")).build());
        policies.put("scope", new MetadataPolicy.Builder().withSubsetOfValues(List.of("openid", "profile", "email", "phone")).build());
        return policies;
    }

    private void buildRequest(@Nullable String lifetime, @Nullable String metadataLocation, @Nullable String relyingPartyId, @Nullable String clientId, @Nullable String replacement) throws UnsupportedEncodingException {
        this.request.setMethod("GET");
        if (lifetime != null) {
            this.request.addParameter("tokenLifetime", URLEncoder.encode(lifetime, "UTF-8"));
        }
        if (metadataLocation != null) {
            this.request.addParameter("policyLocation", metadataLocation);
        }
        if (relyingPartyId != null) {
            this.request.addParameter("policyId", relyingPartyId);
        }
        if (clientId != null) {
            this.request.addParameter("clientId", clientId);
        }
        if (replacement != null) {
            this.request.addParameter("replacement", replacement);
        }
    }

    private void assertErrorResponse(int status, String title) throws UnsupportedEncodingException, JsonMappingException, JsonProcessingException {
        Assert.assertEquals((int)this.response.getStatus(), (int)status);
        String rawResponse = this.response.getContentAsString();
        ObjectMapper objectMapper = new ObjectMapper();
        Errors errors = (Errors)objectMapper.readerFor(Errors.class).readValue(rawResponse);
        Assert.assertNotNull((Object)errors);
        Assert.assertNotNull((Object)errors.getErrors());
        Assert.assertEquals((int)errors.getErrors().size(), (int)1);
        Error error = (Error)errors.getErrors().get(0);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((String)error.getStatus(), (String)("" + status));
        Assert.assertEquals((String)error.getTitle(), (String)title);
    }
}

