/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl;

import com.nimbusds.oauth2.sdk.TokenRevocationRequest;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl.OAuth2RevocationRequestDecoder;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OAuth2RevocationRequestDecoderTest {
    private MockHttpServletRequest httpRequest;
    private OAuth2RevocationRequestDecoder decoder;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.httpRequest = new MockHttpServletRequest();
        this.httpRequest.setMethod("POST");
        this.httpRequest.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
        this.httpRequest.addParameter("token", "45ghiukldjahdnhzdauz");
        this.httpRequest.addParameter("token_type_hint", "refresh_token");
        this.httpRequest.addParameter("client_id", "123456");
        this.decoder = new OAuth2RevocationRequestDecoder();
        this.decoder.setHttpServletRequest((HttpServletRequest)this.httpRequest);
        this.decoder.initialize();
    }

    @Test
    public void testRequestDecoding() throws MessageDecodingException {
        this.decoder.decode();
        MessageContext messageContext = this.decoder.getMessageContext();
        Assert.assertEquals((String)((TokenRevocationRequest)messageContext.getMessage()).getClientID().toString(), (String)"123456");
    }

    @Test(expectedExceptions={MessageDecodingException.class})
    public void testInvalidRequestDecoding() throws MessageDecodingException {
        this.httpRequest.removeParameter("token");
        this.decoder.decode();
    }
}

