/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.decoding.impl;

import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.OIDCTokenRequestDecoder;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OIDCTokenRequestDecoderTest {
    private MockHttpServletRequest httpRequest;
    private OIDCTokenRequestDecoder decoder;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.httpRequest = new MockHttpServletRequest();
        this.httpRequest.setMethod(HTTPRequest.Method.POST.toString());
        this.decoder = new OIDCTokenRequestDecoder();
        this.decoder.setHttpServletRequest((HttpServletRequest)this.httpRequest);
        this.decoder.initialize();
    }

    @Test(expectedExceptions={MessageDecodingException.class})
    public void testInvalidJson() throws MessageDecodingException {
        this.httpRequest.setContent("\"test\" : \"test\" }".getBytes());
        this.httpRequest.setContentType("application/json");
        this.decoder.decode();
    }

    @Test
    public void testRequestDecoding() throws MessageDecodingException, IOException {
        this.httpRequest.addHeader("Authorization", (Object)"Basic czZCaGRSa3F0MzpnWDFmQmF0M2JW");
        this.httpRequest.setContentType("application/x-www-form-urlencoded");
        this.httpRequest.addParameter("grant_type", "authorization_code");
        this.httpRequest.addParameter("code", "SplxlOBeZQQYbYS6WxSbIA");
        this.httpRequest.addParameter("redirect_uri", "https://client.example.org/cb");
        this.decoder.decode();
        MessageContext messageContext = this.decoder.getMessageContext();
        TokenRequest message = (TokenRequest)messageContext.getMessage();
        Assert.assertEquals((String)message.getAuthorizationGrant().getType().getValue(), (String)"authorization_code");
    }
}

