/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.plugin.authn.duo.sdk;

import java.io.IOException;
import java.util.Collections;

import net.shibboleth.idp.module.IdPModule;
import net.shibboleth.idp.module.ModuleException;
import net.shibboleth.idp.plugin.PluginException;
import net.shibboleth.idp.plugin.impl.FirstPartyIdPPlugin;

/**
 * Details about the Duo OIDC 2FA plugin based on the Duo Web SDK v4.
 */
public class DuoOIDCWebSDKPlugin extends FirstPartyIdPPlugin{
    
    
    /**
     * Constructor.
     * 
     * @throws IOException if the properties fail to load
     * @throws PluginException if other errors occur
     */
    public DuoOIDCWebSDKPlugin() throws IOException, PluginException{
        super(DuoOIDCWebSDKPlugin.class);
        try {
            final IdPModule module = new DuoOIDCWebSDKModule();
            setEnableOnInstall(Collections.singleton(module));
            setDisableOnRemoval(Collections.singleton(module));
        } catch (final IOException e) {
            throw e;
        } catch (final ModuleException e) {
            throw new PluginException(e);
        }
    }

}
