/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.nimbusds.jwt.JWT;
import java.text.ParseException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.AbstractDuoAuthenticationAction;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeCodeForDuoToken
extends AbstractDuoAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExchangeCodeForDuoToken.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull DuoOIDCAuthenticationContext duoContext) {
        DuoOIDCClient client = duoContext.getClient();
        if (client == null) {
            this.log.error("{} Duo client is null, has the context been created correctly?", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AuthenticationException");
            return;
        }
        String code = duoContext.getAuthorizationCode();
        if (code == null) {
            this.log.error("{} Duo 2FA authorization code is not available in the response", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        String username = duoContext.getUsername();
        if (username == null) {
            this.log.error("{} Username is not available in the Duo context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        try {
            JWT token = client.exchangeAuthorizationCodeFor2FAResult(code, username, duoContext.getRedirectURIOverride());
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} Duo 2FA token received for subject '{}'", (Object)this.getLogPrefix(), (Object)token.getJWTClaimsSet().getSubject());
            }
            duoContext.setAuthToken(token);
        }
        catch (ParseException | DuoClientException e) {
            this.log.error("{} Unable to exchange authorisation code for 2FA result", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AuthenticationException");
            return;
        }
    }
}

