/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SPSessionSerializerRegistry;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.session.impl.BasicSPSessionSerializer;
import net.shibboleth.idp.session.impl.UpdateSessionWithSPSession;
import net.shibboleth.idp.session.impl.testing.SessionManagerBaseTestCase;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class UpdateSessionWithSPSessionTest
extends SessionManagerBaseTestCase {
    private RequestContext src;
    private ProfileRequestContext prc;
    private UpdateSessionWithSPSession action;

    @BeforeMethod
    public void setUpAction() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.action = new UpdateSessionWithSPSession();
        this.action.setSessionManager((SessionManager)this.sessionManager);
    }

    @Override
    protected void adjustProperties() throws ComponentInitializationException {
        this.sessionManager.setTrackSPSessions(true);
        this.sessionManager.setSecondaryServiceIndex(true);
        SPSessionSerializerRegistry registry = new SPSessionSerializerRegistry();
        registry.setMappings(Collections.singletonMap(BasicSPSession.class, new BasicSPSessionSerializer(Duration.ofSeconds(900L))));
        registry.initialize();
        this.sessionManager.setSPSessionSerializerRegistry(registry);
    }

    @Test
    public void testNoSession() throws ComponentInitializationException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        this.action.setSPSessionCreationStrategy(FunctionSupport.constant(null));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.prc.getSubcontext(SessionContext.class));
    }

    @Test
    public void testNullSession() throws SessionException, ComponentInitializationException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        IdPSession session = this.sessionManager.createSession("joe");
        ((SessionContext)this.prc.getSubcontext(SessionContext.class, true)).setIdPSession(session);
        this.action.setSPSessionCreationStrategy(FunctionSupport.constant(null));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)session.getSPSession("https://sp.example.org"));
    }

    @Test
    public void testBasicSession() throws SessionException, ComponentInitializationException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        IdPSession session = this.sessionManager.createSession("joe");
        ((SessionContext)this.prc.getSubcontext(SessionContext.class, true)).setIdPSession(session);
        Instant creation = Instant.now();
        Instant expiration = creation.plusSeconds(3600L);
        this.action.setSPSessionCreationStrategy((Function)new DummyStrategy(creation, expiration));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SPSession spSession = session.getSPSession("https://sp.example.org");
        Assert.assertNotNull((Object)spSession);
        Assert.assertEquals((Object)spSession.getCreationInstant(), (Object)creation);
        Assert.assertEquals((Object)spSession.getExpirationInstant(), (Object)expiration);
    }

    private class DummyStrategy
    implements Function<ProfileRequestContext, SPSession> {
        private Instant creationTime;
        private Instant expirationTime;

        DummyStrategy(Instant creation, Instant expiration) {
            this.creationTime = creation;
            this.expirationTime = expiration;
        }

        @Override
        public SPSession apply(ProfileRequestContext input) {
            return new BasicSPSession("https://sp.example.org", this.creationTime, this.expirationTime);
        }
    }
}

