/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.io.IOException;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.json.JsonObject;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.impl.DefaultAuthenticationResultSerializer;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.authn.testing.TestPrincipal;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SPSessionSerializerRegistry;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.criterion.HttpServletRequestCriterion;
import net.shibboleth.idp.session.criterion.SPSessionCriterion;
import net.shibboleth.idp.session.criterion.SessionIdCriterion;
import net.shibboleth.idp.session.impl.BasicSPSessionSerializer;
import net.shibboleth.idp.session.impl.testing.SessionManagerBaseTestCase;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class StorageBackedSessionManagerTest
extends SessionManagerBaseTestCase {
    private static final Duration sessionSlop = Duration.ofMinutes(5L);
    private static final Logger log = LoggerFactory.getLogger(StorageBackedSessionManagerTest.class);
    private Collection<AuthenticationFlowDescriptor> flowDescriptors;
    private SPSessionSerializerRegistry serializerRegistry;

    @Override
    @BeforeClass
    public void setUp() throws ComponentInitializationException {
        this.serializerRegistry = new SPSessionSerializerRegistry();
        HashMap<Class, BasicSPSessionSerializer> map = new HashMap<Class, BasicSPSessionSerializer>();
        map.put(BasicSPSession.class, new BasicSPSessionSerializer(sessionSlop));
        map.put(ExtendedSPSession.class, new ExtendedSPSessionSerializer(sessionSlop));
        this.serializerRegistry.setMappings(map);
        this.serializerRegistry.initialize();
        DefaultAuthenticationResultSerializer resultSerializer = new DefaultAuthenticationResultSerializer();
        resultSerializer.initialize();
        AuthenticationFlowDescriptor foo = new AuthenticationFlowDescriptor();
        foo.setId("AuthenticationFlow/Foo");
        foo.setLifetime(Duration.ofMinutes(1L));
        foo.setInactivityTimeout(Duration.ofMinutes(1L));
        foo.setResultSerializer((StorageSerializer)resultSerializer);
        foo.initialize();
        AuthenticationFlowDescriptor bar = new AuthenticationFlowDescriptor();
        bar.setId("AuthenticationFlow/Bar");
        bar.setLifetime(Duration.ofMinutes(1L));
        bar.setInactivityTimeout(Duration.ofMinutes(1L));
        bar.setResultSerializer((StorageSerializer)resultSerializer);
        bar.initialize();
        this.flowDescriptors = Arrays.asList(foo, bar);
        super.setUp();
    }

    @Override
    protected void adjustProperties() {
        this.sessionManager.setAuthenticationFlowDescriptors(this.flowDescriptors);
        this.sessionManager.setTrackSPSessions(true);
        this.sessionManager.setSecondaryServiceIndex(true);
        this.sessionManager.setSessionSlop(sessionSlop);
        this.sessionManager.setSPSessionSerializerRegistry(this.serializerRegistry);
    }

    @Test
    public void testEmptyCookie() throws ResolverException, SessionException, InterruptedException {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest();
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)mockRequest, (HttpServletResponse)new MockHttpServletResponse());
        Cookie cookie = new Cookie("shib_idp_session", "");
        mockRequest.setCookies(new Cookie[]{cookie});
        Assert.assertNull((Object)this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()})));
    }

    @Test(threadPoolSize=10, invocationCount=10, timeOut=10000L)
    public void testSimpleSession() throws ResolverException, SessionException, InterruptedException {
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)mockResponse);
        Assert.assertNull((Object)this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion("test")})));
        try {
            this.sessionManager.createSession(null);
            Assert.fail((String)"A null username should not have worked");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        IdPSession session = this.sessionManager.createSession("joe");
        Assert.assertTrue((session.getCreationInstant().compareTo(Instant.now()) <= 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)session.getCreationInstant(), (Object)session.getLastActivityInstant());
        Assert.assertEquals((String)session.getPrincipalName(), (String)"joe");
        Assert.assertTrue((boolean)session.getAuthenticationResults().isEmpty());
        Assert.assertTrue((boolean)session.getSPSessions().isEmpty());
        Assert.assertEquals((String)mockResponse.getCookie("shib_idp_session").getValue(), (String)session.getId());
        log.trace("testSimpleSession({}): \n\tTime before sleep: {} \n\tCreation Instant: {}\n\t Last Activity : {} ", new Object[]{Thread.currentThread().toString(), Instant.now().toString(), session.getCreationInstant().toString(), session.getLastActivityInstant().toString()});
        Thread.sleep(1000L);
        log.trace("testSimpleSession({}): \n\tTime after sleep: {} \n\tCreation Instant: {}\n\t Last Activity : {} ", new Object[]{Thread.currentThread().toString(), Instant.now().toString(), session.getCreationInstant().toString(), session.getLastActivityInstant().toString()});
        session.checkTimeout();
        log.trace("testSimpleSession({}): \n\tTime after checkTimeOut : {} \n\tCreation Instant: {}\n\t Last Activity : {} ", new Object[]{Thread.currentThread().toString(), Instant.now().toString(), session.getCreationInstant().toString(), session.getLastActivityInstant().toString()});
        Assert.assertNotEquals((Object)session.getCreationInstant(), (Object)session.getLastActivityInstant());
        Instant creation = session.getCreationInstant();
        Instant lastActivity = session.getLastActivityInstant();
        String sessionId = session.getId();
        session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(sessionId)}));
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((String)session.getPrincipalName(), (String)"joe");
        Assert.assertEquals((Object)session.getCreationInstant(), (Object)creation.truncatedTo(ChronoUnit.MILLIS));
        Assert.assertEquals((Object)session.getLastActivityInstant(), (Object)lastActivity.truncatedTo(ChronoUnit.MILLIS));
        this.sessionManager.destroySession(sessionId, true);
        Assert.assertNull((Object)this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(sessionId)})));
    }

    @Test(threadPoolSize=10, invocationCount=10, timeOut=10000L)
    public void testAddress() throws SessionException, ResolverException {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest();
        mockRequest.setRemoteAddr("192.168.1.1");
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)mockRequest, (HttpServletResponse)new MockHttpServletResponse());
        IdPSession session = this.sessionManager.createSession("joe");
        Assert.assertTrue((boolean)session.checkAddress("192.168.1.1"));
        Assert.assertFalse((boolean)session.checkAddress("192.168.1.2"));
        Assert.assertTrue((boolean)session.checkAddress("fe80::ca2a:14ff:fe2a:3e04"));
        Assert.assertTrue((boolean)session.checkAddress("fe80::ca2a:14ff:fe2a:3e04"));
        Assert.assertFalse((boolean)session.checkAddress("fe80::ca2a:14ff:fe2a:3e05"));
        Assert.assertTrue((boolean)session.checkAddress("192.168.1.1"));
        Assert.assertFalse((boolean)session.checkAddress("1,1,1,1"));
        IdPSession one = this.sessionManager.createSession("joe");
        IdPSession two = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(one.getId())}));
        Assert.assertTrue((boolean)one.checkAddress("192.168.1.1"));
        Assert.assertFalse((boolean)two.checkAddress("192.168.1.2"));
        Assert.assertTrue((boolean)two.checkAddress("fe80::ca2a:14ff:fe2a:3e04"));
        Assert.assertFalse((boolean)one.checkAddress("fe80::ca2a:14ff:fe2a:3e05"));
        this.sessionManager.destroySession(session.getId(), true);
    }

    @Test(threadPoolSize=10, invocationCount=10, timeOut=10000L)
    public void testAuthenticationResults() throws ResolverException, SessionException, InterruptedException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        IdPSession session = this.sessionManager.createSession("joe");
        Assert.assertTrue((boolean)session.getAuthenticationResults().isEmpty());
        AuthenticationResult foo = new AuthenticationResult("AuthenticationFlow/Foo", (Principal)new UsernamePrincipal("joe"));
        foo.getSubject().getPrincipals().add((Principal)new TestPrincipal("test1"));
        AuthenticationResult bar = new AuthenticationResult("AuthenticationFlow/Bar", (Principal)new UsernamePrincipal("joe"));
        bar.getSubject().getPrincipals().add((Principal)new TestPrincipal("test2"));
        AuthenticationResult baz = new AuthenticationResult("AuthenticationFlow/Baz", (Principal)new UsernamePrincipal("joe"));
        Assert.assertNull((Object)session.addAuthenticationResult(foo));
        Assert.assertNull((Object)session.addAuthenticationResult(bar));
        try {
            session.addAuthenticationResult(baz);
            Assert.fail((String)"An unserializable AuthenticationResult should not have worked");
        }
        catch (SessionException sessionException) {
            // empty catch block
        }
        Assert.assertEquals((int)session.getAuthenticationResults().size(), (int)2);
        Assert.assertFalse((boolean)session.removeAuthenticationResult(baz));
        Assert.assertTrue((boolean)session.removeAuthenticationResult(bar));
        Assert.assertEquals((int)session.getAuthenticationResults().size(), (int)1);
        Assert.assertNull((Object)session.getAuthenticationResult("AuthenticationFlow/Bar"));
        AuthenticationResult foo2 = session.getAuthenticationResult("AuthenticationFlow/Foo");
        Assert.assertSame((Object)foo, (Object)foo2);
        foo.setLastActivityInstant(Instant.ofEpochMilli(System.currentTimeMillis()));
        session.updateAuthenticationResultActivity(foo);
        IdPSession session2 = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(session.getId())}));
        Assert.assertNull((Object)session2.getAuthenticationResult("AuthenticationFlow/Bar"));
        foo2 = session2.getAuthenticationResult("AuthenticationFlow/Foo");
        Assert.assertNotNull((Object)foo2);
        Assert.assertEquals((Object)foo.getAuthenticationInstant().truncatedTo(ChronoUnit.MILLIS), (Object)foo2.getAuthenticationInstant());
        Assert.assertEquals((Object)foo.getLastActivityInstant(), (Object)foo2.getLastActivityInstant());
        Assert.assertEquals((Object)foo.getSubject(), (Object)foo2.getSubject());
        session2 = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(session.getId())}));
        Assert.assertTrue((boolean)session.removeAuthenticationResult(foo));
        Assert.assertNull((Object)session2.getAuthenticationResult("AuthenticationFlow/Foo"));
        this.sessionManager.destroySession(session.getId(), true);
    }

    @Test(threadPoolSize=10, invocationCount=10, timeOut=10000L)
    public void testSPSessions() throws ResolverException, SessionException, InterruptedException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        IdPSession session = this.sessionManager.createSession("joe");
        Assert.assertTrue((boolean)session.getSPSessions().isEmpty());
        Instant now = Instant.now();
        BasicSPSession foo = new BasicSPSession("https://sp.example.org/shibboleth", now, now.plusSeconds(3600L));
        BasicSPSession bar = new BasicSPSession("https://sp2.example.org/shibboleth", now, now.plusSeconds(3600L));
        Assert.assertNull((Object)session.addSPSession((SPSession)foo));
        Assert.assertNull((Object)session.addSPSession((SPSession)bar));
        Assert.assertEquals((int)session.getSPSessions().size(), (int)2);
        Assert.assertTrue((boolean)session.removeSPSession((SPSession)bar));
        Assert.assertFalse((boolean)session.removeSPSession((SPSession)bar));
        Assert.assertEquals((int)session.getSPSessions().size(), (int)1);
        Assert.assertNull((Object)session.getSPSession("https://sp2.example.org/shibboleth"));
        SPSession foo2 = session.getSPSession("https://sp.example.org/shibboleth");
        Assert.assertNotNull((Object)foo2);
        Assert.assertEquals((Object)foo.getCreationInstant(), (Object)foo2.getCreationInstant());
        Assert.assertEquals((Object)foo.getExpirationInstant(), (Object)foo2.getExpirationInstant());
        IdPSession session2 = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(session.getId())}));
        Assert.assertNull((Object)session.getSPSession("https://sp2.example.org/shibboleth"));
        foo2 = session2.getSPSession("https://sp.example.org/shibboleth");
        Assert.assertNotNull((Object)foo2);
        Assert.assertEquals((Object)foo.getCreationInstant().truncatedTo(ChronoUnit.MILLIS), (Object)foo2.getCreationInstant());
        Assert.assertEquals((Object)foo.getExpirationInstant().truncatedTo(ChronoUnit.MILLIS), (Object)foo2.getExpirationInstant());
        session2 = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(session.getId())}));
        Assert.assertTrue((boolean)session.removeSPSession((SPSession)foo));
        Assert.assertNull((Object)session2.getSPSession("https://sp.example.org/shibboleth"));
        this.sessionManager.destroySession(session.getId(), true);
    }

    @Test
    public void testSecondaryLookup() throws ResolverException, SessionException, InterruptedException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        IdPSession session = this.sessionManager.createSession("joe");
        IdPSession session2 = this.sessionManager.createSession("joe2");
        Instant now = Instant.now();
        ExtendedSPSession foo = new ExtendedSPSession("https://sp.example.org/shibboleth", now, now.plusSeconds(3600L));
        ExtendedSPSession bar = new ExtendedSPSession("https://sp2.example.org/shibboleth", now, now.plusSeconds(3600L));
        Assert.assertNull((Object)session.addSPSession((SPSession)foo));
        Assert.assertNull((Object)session.addSPSession((SPSession)bar));
        Assert.assertNull((Object)session2.addSPSession((SPSession)foo));
        Assert.assertNull((Object)session2.addSPSession((SPSession)bar));
        Assert.assertFalse((boolean)this.sessionManager.resolve(new CriteriaSet(new Criterion[]{new SPSessionCriterion("https://sp.example.org/shibboleth", "None")})).iterator().hasNext());
        ArrayList<IdPSession> sessions = new ArrayList<IdPSession>();
        for (IdPSession s : this.sessionManager.resolve(new CriteriaSet(new Criterion[]{new SPSessionCriterion("https://sp.example.org/shibboleth", "PerSessionNameWouldGoHere")}))) {
            sessions.add(s);
        }
        Assert.assertEquals((int)sessions.size(), (int)2);
        this.sessionManager.destroySession(session.getId(), true);
        sessions.clear();
        for (IdPSession s : this.sessionManager.resolve(new CriteriaSet(new Criterion[]{new SPSessionCriterion("https://sp2.example.org/shibboleth", "PerSessionNameWouldGoHere")}))) {
            sessions.add(s);
        }
        Assert.assertEquals((int)sessions.size(), (int)1);
        this.sessionManager.destroySession(session2.getId(), true);
        sessions.clear();
        for (IdPSession s : this.sessionManager.resolve(new CriteriaSet(new Criterion[]{new SPSessionCriterion("https://sp2.example.org/shibboleth", "PerSessionNameWouldGoHere")}))) {
            sessions.add(s);
        }
        Assert.assertEquals((int)sessions.size(), (int)0);
    }

    private static class ExtendedSPSessionSerializer
    extends BasicSPSessionSerializer {
        public ExtendedSPSessionSerializer(Duration offset) {
            super(offset);
        }

        protected SPSession doDeserialize(JsonObject obj, String id, Instant creation, Instant expiration) throws IOException {
            obj.getString("sk");
            return new ExtendedSPSession(id, creation, expiration);
        }

        protected void doSerializeAdditional(SPSession instance, JsonGenerator generator) {
            generator.write("sk", "PerSessionNameWouldGoHere");
        }
    }

    private static class ExtendedSPSession
    extends BasicSPSession {
        public static final String SESSION_KEY = "PerSessionNameWouldGoHere";

        public ExtendedSPSession(String id, Instant creation, Instant expiration) {
            super(id, creation, expiration);
        }

        public String getSPSessionKey() {
            return SESSION_KEY;
        }
    }
}

