/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SPSessionSerializerRegistry;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.criterion.HttpServletRequestCriterion;
import net.shibboleth.idp.session.criterion.SPSessionCriterion;
import net.shibboleth.idp.session.criterion.SessionIdCriterion;
import net.shibboleth.idp.session.impl.StorageBackedIdPSession;
import net.shibboleth.idp.session.impl.StorageBackedIdPSessionSerializer;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.CookieManager;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.VersionMismatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageBackedSessionManager
extends AbstractIdentifiableInitializableComponent
implements SessionManager,
SessionResolver {
    @Nonnull
    @NotEmpty
    public static final String SESSION_MASTER_KEY = "_session";
    @Nonnull
    @NotEmpty
    protected static final String DEFAULT_COOKIE_NAME = "shib_idp_session";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StorageBackedSessionManager.class);
    @Nullable
    private HttpServletRequest httpRequest;
    @Nullable
    private HttpServletResponse httpResponse;
    @Duration
    @Positive
    private long sessionTimeout = 3600000L;
    @Duration
    @NonNegative
    private long sessionSlop;
    private boolean maskStorageFailure;
    private boolean trackSPSessions;
    private boolean secondaryServiceIndex;
    private boolean consistentAddress = true;
    @NonnullAfterInit
    private CookieManager cookieManager;
    @Nonnull
    @NotEmpty
    private String cookieName = "shib_idp_session";
    @NonnullAfterInit
    private StorageService storageService;
    private long storageServiceThreshold = 0x100000L;
    @NonnullAfterInit
    private IdentifierGenerationStrategy idGenerator;
    @Nonnull
    private final StorageBackedIdPSessionSerializer serializer = new StorageBackedIdPSessionSerializer(this, null);
    @Nonnull
    @NonnullElements
    private final Map<String, AuthenticationFlowDescriptor> flowDescriptorMap = new HashMap<String, AuthenticationFlowDescriptor>();
    @Nullable
    private SPSessionSerializerRegistry spSessionSerializerRegistry;

    public void setHttpServletRequest(@Nullable HttpServletRequest request) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpRequest = request;
    }

    public void setHttpServletResponse(@Nullable HttpServletResponse response) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpResponse = response;
    }

    @Duration
    @Positive
    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Duration
    public void setSessionTimeout(@Duration @Positive long timeout) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionTimeout = Constraint.isGreaterThan((long)0L, (long)timeout, (String)"Timeout must be greater than zero");
    }

    @Duration
    @Positive
    public long getSessionSlop() {
        return this.sessionSlop;
    }

    @Duration
    public void setSessionSlop(@Duration @NonNegative long slop) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionSlop = Constraint.isGreaterThanOrEqual((long)0L, (long)slop, (String)"Slop must be greater than or equal to zero");
    }

    public boolean isMaskStorageFailure() {
        return this.maskStorageFailure;
    }

    public void setMaskStorageFailure(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.maskStorageFailure = flag;
    }

    public boolean isTrackSPSessions() {
        return this.trackSPSessions;
    }

    public void setTrackSPSessions(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.trackSPSessions = flag;
    }

    public boolean isSecondaryServiceIndex() {
        return this.secondaryServiceIndex;
    }

    public void setSecondaryServiceIndex(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.secondaryServiceIndex = flag;
    }

    public boolean isConsistentAddress() {
        return this.consistentAddress;
    }

    public void setConsistentAddress(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.consistentAddress = flag;
    }

    public void setCookieName(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.cookieName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Cookie name cannot be null or empty");
    }

    public void setCookieManager(@Nonnull CookieManager manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.cookieManager = (CookieManager)Constraint.isNotNull((Object)manager, (String)"CookieManager cannot be null");
    }

    @Nonnull
    public StorageService getStorageService() {
        return this.storageService;
    }

    public void setStorageService(@Nonnull StorageService storage) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.storageService = (StorageService)Constraint.isNotNull((Object)storage, (String)"StorageService cannot be null");
    }

    public boolean storageServiceMeetsThreshold() {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return this.storageService.getCapabilities().getValueSize() >= this.storageServiceThreshold;
    }

    public void setStorageServiceThreshold(long size) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.storageServiceThreshold = size;
    }

    public void setIDGenerator(@Nonnull IdentifierGenerationStrategy newIDGenerator) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGenerator = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)newIDGenerator, (String)"IdentifierGenerationStrategy cannot be null");
    }

    @Nonnull
    public StorageSerializer<StorageBackedIdPSession> getStorageSerializer() {
        return this.serializer;
    }

    @Nullable
    public AuthenticationFlowDescriptor getAuthenticationFlowDescriptor(@Nonnull @NotEmpty String flowId) {
        return this.flowDescriptorMap.get(flowId);
    }

    public void setAuthenticationFlowDescriptors(@Nonnull @NonnullElements Iterable<AuthenticationFlowDescriptor> flows) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(flows, (String)"Flow collection cannot be null");
        this.flowDescriptorMap.clear();
        for (AuthenticationFlowDescriptor desc : Iterables.filter(flows, (Predicate)Predicates.notNull())) {
            this.flowDescriptorMap.put(desc.getId(), desc);
        }
    }

    @Nullable
    public SPSessionSerializerRegistry getSPSessionSerializerRegistry() {
        return this.spSessionSerializerRegistry;
    }

    public void setSPSessionSerializerRegistry(@Nullable SPSessionSerializerRegistry registry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.spSessionSerializerRegistry = registry;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.storageService == null) {
            throw new ComponentInitializationException("Initialization of StorageBackedSessionManager requires non-null StorageService");
        }
        if (this.idGenerator == null) {
            throw new ComponentInitializationException("Initialization of StorageBackedSessionManager requires non-null IdentifierGenerationStrategy");
        }
        if (this.cookieManager == null) {
            throw new ComponentInitializationException("Initialization of StorageBackedSessionManager requires non-null CookieManager");
        }
        if (this.trackSPSessions && this.spSessionSerializerRegistry == null) {
            throw new ComponentInitializationException("Tracking SPSessions requires a spSessionSerializerRegistry");
        }
        this.serializer.initialize();
    }

    @Nonnull
    public IdPSession createSession(@Nonnull @NotEmpty String principalName) throws SessionException {
        StorageBackedIdPSession newSession;
        String sessionId;
        block8: {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
            String remoteAddr = null;
            if (this.consistentAddress) {
                if (this.httpRequest == null) {
                    throw new SessionException("No HttpServletRequest available, can't bind to client address");
                }
                remoteAddr = StringSupport.trimOrNull((String)this.httpRequest.getRemoteAddr());
                if (remoteAddr == null) {
                    throw new SessionException("No client address to bind");
                }
            }
            if ((sessionId = this.idGenerator.generateIdentifier(false)).length() > this.storageService.getCapabilities().getContextSize()) {
                throw new SessionException("Session IDs are too large for StorageService, check configuration");
            }
            newSession = new StorageBackedIdPSession(this, sessionId, principalName, System.currentTimeMillis());
            if (remoteAddr != null) {
                newSession.doBindToAddress(remoteAddr);
            }
            try {
                if (!this.storageService.create(sessionId, SESSION_MASTER_KEY, (Object)newSession, (StorageSerializer)this.serializer, Long.valueOf(newSession.getCreationInstant() + this.sessionTimeout + this.sessionSlop))) {
                    throw new SessionException("A duplicate session ID was generated, unable to create session");
                }
            }
            catch (IOException e) {
                this.log.error("Exception while storing new session for principal {}", (Object)principalName, (Object)e);
                if (this.maskStorageFailure) break block8;
                throw new SessionException("Exception while storing new session", (Exception)e);
            }
        }
        this.log.debug("Created new session {} for principal {}", (Object)sessionId, (Object)principalName);
        this.cookieManager.addCookie(this.cookieName, sessionId);
        return newSession;
    }

    public void destroySession(@Nonnull @NotEmpty String sessionId, boolean unbind) throws SessionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (unbind) {
            this.cookieManager.unsetCookie(this.cookieName);
        }
        try {
            this.storageService.deleteContext(sessionId);
            this.log.debug("Destroyed session {}", (Object)sessionId);
        }
        catch (IOException e) {
            this.log.error("Exception while destroying session {}", (Object)sessionId, (Object)e);
            throw new SessionException("Exception while destroying session", (Exception)e);
        }
    }

    @Nonnull
    @NonnullElements
    public Iterable<IdPSession> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (criteria != null) {
            HttpServletRequestCriterion requestCriterion = (HttpServletRequestCriterion)criteria.get(HttpServletRequestCriterion.class);
            if (requestCriterion != null) {
                if (this.httpRequest != null) {
                    Cookie[] cookies = this.httpRequest.getCookies();
                    if (cookies != null) {
                        for (Cookie cookie : cookies) {
                            IdPSession session;
                            if (!this.cookieName.equals(cookie.getName()) || (session = this.lookupBySessionId(cookie.getValue())) == null) continue;
                            return ImmutableList.of((Object)session);
                        }
                    }
                    return ImmutableList.of();
                }
                throw new ResolverException("HttpServletRequest is null");
            }
            SessionIdCriterion sessionIdCriterion = (SessionIdCriterion)criteria.get(SessionIdCriterion.class);
            if (sessionIdCriterion != null) {
                IdPSession session = this.lookupBySessionId(sessionIdCriterion.getSessionId());
                if (session != null) {
                    return ImmutableList.of((Object)session);
                }
                return ImmutableList.of();
            }
            SPSessionCriterion serviceCriterion = (SPSessionCriterion)criteria.get(SPSessionCriterion.class);
            if (serviceCriterion != null) {
                if (!this.secondaryServiceIndex) {
                    throw new ResolverException("Secondary service index is disabled (must be enabled for SAML logout)");
                }
                return this.lookupBySPSession(serviceCriterion);
            }
        }
        throw new ResolverException("No supported criterion supplied");
    }

    @Nullable
    public IdPSession resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<IdPSession> i = this.resolve(criteria).iterator();
        if (i != null && i.hasNext()) {
            return i.next();
        }
        return null;
    }

    protected void indexBySPSession(@Nonnull IdPSession idpSession, @Nonnull SPSession spSession, int attempts) throws SessionException {
        if (attempts <= 0) {
            this.log.error("Exceeded retry attempts while adding to secondary index");
            if (!this.maskStorageFailure) {
                throw new SessionException("Exceeded retry attempts while adding to secondary index");
            }
        } else if (this.secondaryServiceIndex && this.storageServiceMeetsThreshold()) {
            StorageRecord sessionList;
            String serviceKey;
            String serviceId;
            block19: {
                serviceId = spSession.getId();
                serviceKey = spSession.getSPSessionKey();
                if (serviceKey == null) {
                    return;
                }
                this.log.debug("Maintaining secondary index for service ID {} and key {}", (Object)serviceId, (Object)serviceKey);
                int contextSize = this.storageService.getCapabilities().getContextSize();
                int keySize = this.storageService.getCapabilities().getKeySize();
                if (serviceId.length() > contextSize) {
                    serviceId = serviceId.substring(0, contextSize);
                }
                if (serviceKey.length() > keySize) {
                    serviceKey = serviceKey.substring(0, keySize);
                }
                sessionList = null;
                try {
                    sessionList = this.storageService.read(serviceId, serviceKey);
                }
                catch (IOException e) {
                    this.log.error("Exception while querying based service ID {} and key {}", new Object[]{serviceId, serviceKey, e});
                    if (this.maskStorageFailure) break block19;
                    throw new SessionException("Exception while querying based on SPSession", (Exception)e);
                }
            }
            try {
                if (sessionList != null) {
                    if (!sessionList.getValue().contains(idpSession.getId() + ',')) {
                        String updated = sessionList.getValue() + idpSession.getId() + ',';
                        if (this.storageService.updateWithVersion(sessionList.getVersion(), serviceId, serviceKey, updated, Long.valueOf(Math.max(sessionList.getExpiration(), spSession.getExpirationInstant() + this.sessionSlop))) == null) {
                            this.log.debug("Secondary index record disappeared, retrying as insert");
                            this.indexBySPSession(idpSession, spSession, attempts - 1);
                        }
                    } else {
                        this.log.debug("IdP session {} already indexed against service ID {} and key {}", new Object[]{idpSession.getId(), serviceId, serviceKey});
                    }
                } else if (!this.storageService.create(serviceId, serviceKey, idpSession.getId() + ',', Long.valueOf(spSession.getExpirationInstant() + this.sessionSlop))) {
                    this.log.debug("Secondary index record appeared, retrying as update");
                    this.indexBySPSession(idpSession, spSession, attempts - 1);
                }
            }
            catch (IOException e) {
                this.log.error("Exception maintaining secondary index for service ID {} and key {}", new Object[]{serviceId, serviceKey, e});
                if (!this.maskStorageFailure) {
                    throw new SessionException("Exception maintaining secondary index", (Exception)e);
                }
            }
            catch (VersionMismatchException e) {
                this.log.debug("Secondary index record was updated between read/update, retrying");
                this.indexBySPSession(idpSession, spSession, attempts - 1);
            }
        }
    }

    protected void unindexSPSession(@Nonnull IdPSession idpSession, @Nonnull SPSession spSession, int attempts) throws SessionException {
        if (attempts <= 0) {
            this.log.error("Exceeded retry attempts while removing from secondary index");
            if (!this.maskStorageFailure) {
                throw new SessionException("Exceeded retry attempts while removing from secondary index");
            }
        } else if (this.secondaryServiceIndex && this.storageServiceMeetsThreshold()) {
            StorageRecord sessionList;
            String serviceKey;
            String serviceId;
            block20: {
                serviceId = spSession.getId();
                serviceKey = spSession.getSPSessionKey();
                if (serviceKey == null) {
                    return;
                }
                this.log.debug("Removing secondary index for service ID {} and key {}", (Object)serviceId, (Object)serviceKey);
                int contextSize = this.storageService.getCapabilities().getContextSize();
                int keySize = this.storageService.getCapabilities().getKeySize();
                if (serviceId.length() > contextSize) {
                    serviceId = serviceId.substring(0, contextSize);
                }
                if (serviceKey.length() > keySize) {
                    serviceKey = serviceKey.substring(0, keySize);
                }
                sessionList = null;
                try {
                    sessionList = this.storageService.read(serviceId, serviceKey);
                }
                catch (IOException e) {
                    this.log.error("Exception while querying based service ID {} and key {}", new Object[]{serviceId, serviceKey, e});
                    if (this.maskStorageFailure) break block20;
                    throw new SessionException("Exception while querying based on SPSession", (Exception)e);
                }
            }
            try {
                if (sessionList != null) {
                    String recordValue = sessionList.getValue();
                    if (recordValue.contains(idpSession.getId() + ',')) {
                        String updated = recordValue.replace(idpSession.getId() + ',', "");
                        if (updated.length() > 0) {
                            if (this.storageService.updateWithVersion(sessionList.getVersion(), serviceId, serviceKey, updated, sessionList.getExpiration()) == null) {
                                this.log.debug("Secondary index record disappeared, nothing to do");
                            }
                        } else {
                            this.storageService.deleteWithVersion(sessionList.getVersion(), serviceId, serviceKey);
                        }
                    } else {
                        this.log.debug("IdP session {} not indexed against service ID {} and key {}", new Object[]{idpSession.getId(), serviceId, serviceKey});
                    }
                } else {
                    this.log.debug("Secondary index record not found, nothing to do");
                }
            }
            catch (IOException e) {
                this.log.error("Exception removing secondary index for service ID {} and key {}", new Object[]{serviceId, serviceKey, e});
                if (!this.maskStorageFailure) {
                    throw new SessionException("Exception maintaining secondary index", (Exception)e);
                }
            }
            catch (VersionMismatchException e) {
                this.log.debug("Secondary index record was updated between read/update/delete, retrying");
                this.unindexSPSession(idpSession, spSession, attempts - 1);
            }
        }
    }

    @Nullable
    private IdPSession lookupBySessionId(@Nullable String sessionId) throws ResolverException {
        block4: {
            if (Strings.isNullOrEmpty((String)sessionId)) {
                this.log.debug("Lookup of null/empty session ID");
                return null;
            }
            this.log.debug("Performing primary lookup on session ID {}", (Object)sessionId);
            try {
                StorageRecord sessionRecord = this.storageService.read(sessionId, SESSION_MASTER_KEY);
                if (sessionRecord != null) {
                    return (IdPSession)sessionRecord.getValue((StorageSerializer)this.serializer, sessionId, SESSION_MASTER_KEY);
                }
                this.log.debug("Primary lookup failed for session ID {}", (Object)sessionId);
            }
            catch (IOException e) {
                this.log.error("Exception while querying for session ID {}", (Object)sessionId, (Object)e);
                if (this.maskStorageFailure) break block4;
                throw new ResolverException("Exception while querying for session", (Exception)e);
            }
        }
        return null;
    }

    @Nonnull
    @NonnullElements
    private Iterable<IdPSession> lookupBySPSession(@Nonnull SPSessionCriterion criterion) throws ResolverException {
        StorageRecord sessionList;
        String serviceKey;
        String serviceId;
        block12: {
            int contextSize = this.storageService.getCapabilities().getContextSize();
            int keySize = this.storageService.getCapabilities().getKeySize();
            serviceId = criterion.getServiceId();
            serviceKey = criterion.getSPSessionKey();
            this.log.debug("Performing secondary lookup on service ID {} and key {}", (Object)serviceId, (Object)serviceKey);
            if (serviceId.length() > contextSize) {
                serviceId = serviceId.substring(0, contextSize);
            }
            if (serviceKey.length() > keySize) {
                serviceKey = serviceKey.substring(0, keySize);
            }
            sessionList = null;
            try {
                sessionList = this.storageService.read(serviceId, serviceKey);
            }
            catch (IOException e) {
                this.log.error("Exception while querying based service ID {} and key {}", new Object[]{serviceId, serviceKey, e});
                if (this.maskStorageFailure) break block12;
                throw new ResolverException("Exception while querying based on SPSession", (Exception)e);
            }
        }
        if (sessionList == null) {
            this.log.debug("Secondary lookup failed on service ID {} and key {}", (Object)serviceId, (Object)serviceKey);
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        StringBuilder writeBackSessionList = new StringBuilder(sessionList.getValue().length());
        for (String sessionId : sessionList.getValue().split(",")) {
            IdPSession session = this.lookupBySessionId(sessionId);
            if (session == null) continue;
            builder.add((Object)session);
            writeBackSessionList.append(sessionId);
            writeBackSessionList.append(',');
        }
        try {
            String writeBackValue = writeBackSessionList.toString();
            if (writeBackValue.length() == 0) {
                this.storageService.deleteWithVersion(sessionList.getVersion(), serviceId, serviceKey);
            } else if (!writeBackValue.equals(sessionList.getValue())) {
                this.storageService.updateWithVersion(sessionList.getVersion(), serviceId, serviceKey, writeBackValue, sessionList.getExpiration());
            }
        }
        catch (IOException e) {
            this.log.warn("Ignoring exception while updating secondary index", (Throwable)e);
        }
        catch (VersionMismatchException e) {
            this.log.debug("Ignoring version mismatch while updating secondary index");
        }
        return builder.build();
    }
}

