/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.session.criterion.HttpServletRequestCriterion;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateSessionContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateSessionContext.class);
    @NonnullAfterInit
    private SessionResolver sessionResolver;
    @Nonnull
    private Predicate<ProfileRequestContext> checkAddressCondition = Predicates.alwaysTrue();
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextCreationStrategy = new ChildContextLookup(SessionContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, CriteriaSet> sessionResolverCriteriaStrategy = new Function<ProfileRequestContext, CriteriaSet>(){

        public CriteriaSet apply(ProfileRequestContext input) {
            return new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()});
        }
    };

    public void setCheckAddressCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.checkAddressCondition = (Predicate)Constraint.isNotNull(condition, (String)"Address checking condition cannot be null");
    }

    public void setSessionResolver(@Nonnull SessionResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionResolver = (SessionResolver)Constraint.isNotNull((Object)resolver, (String)"SessionResolver cannot be null");
    }

    public void setSessionContextCreationStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext creation strategy cannot be null");
    }

    public void setSessionResolverCriteriaStrategy(@Nonnull Function<ProfileRequestContext, CriteriaSet> strategy) {
        this.sessionResolverCriteriaStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionResolver CriteriaSet strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!this.getActivationCondition().equals((Object)Predicates.alwaysFalse()) && this.sessionResolver == null) {
            throw new ComponentInitializationException("SessionResolver cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        IdPSession session = null;
        try {
            session = (IdPSession)this.sessionResolver.resolveSingle(this.sessionResolverCriteriaStrategy.apply((Object)profileRequestContext));
            if (session == null) {
                this.log.debug("{} No session found for client", (Object)this.getLogPrefix());
                return;
            }
            if (!session.checkTimeout()) {
                this.log.info("{} Session {} no longer valid due to inactivity", (Object)this.getLogPrefix(), (Object)session.getId());
                return;
            }
            if (this.checkAddressCondition.apply((Object)profileRequestContext)) {
                HttpServletRequest request = this.getHttpServletRequest();
                if (request != null && request.getRemoteAddr() != null) {
                    if (!session.checkAddress(request.getRemoteAddr())) {
                        return;
                    }
                } else {
                    this.log.info("{} No servlet request or client address available, skipping address check for session {}", (Object)this.getLogPrefix(), (Object)session.getId());
                }
            } else {
                this.log.debug("{} Bypassing address check for session {}", (Object)this.getLogPrefix(), (Object)session.getId());
            }
            SessionContext sessionCtx = (SessionContext)this.sessionContextCreationStrategy.apply((Object)profileRequestContext);
            if (sessionCtx == null) {
                this.log.error("{} Unable to create or locate SessionContext", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return;
            }
            sessionCtx.setIdPSession(session);
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving a session for the active client", (Object)this.getLogPrefix(), (Object)e);
        }
        catch (SessionException e) {
            this.log.error("{} Error during timeout or address checking for session {}", new Object[]{this.getLogPrefix(), session.getId(), e});
        }
    }
}

