/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import com.google.common.base.Function;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.profile.ActionTestingSupport;
import net.shibboleth.idp.profile.RequestContextBuilder;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SPSessionSerializerRegistry;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.session.impl.BasicSPSessionSerializer;
import net.shibboleth.idp.session.impl.SessionManagerBaseTestCase;
import net.shibboleth.idp.session.impl.UpdateSessionWithSPSession;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class UpdateSessionWithSPSessionTest
extends SessionManagerBaseTestCase {
    private RequestContext src;
    private ProfileRequestContext prc;
    private UpdateSessionWithSPSession action;

    @BeforeMethod
    public void setUpAction() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.action = new UpdateSessionWithSPSession();
        this.action.setSessionManager((SessionManager)this.sessionManager);
    }

    @Override
    protected void adjustProperties() throws ComponentInitializationException {
        this.sessionManager.setTrackSPSessions(true);
        this.sessionManager.setSecondaryServiceIndex(true);
        SPSessionSerializerRegistry registry = new SPSessionSerializerRegistry();
        registry.setMappings(Collections.singletonMap(BasicSPSession.class, new BasicSPSessionSerializer(54000000L)));
        registry.initialize();
        this.sessionManager.setSPSessionSerializerRegistry(registry);
    }

    @Test
    public void testNoSession() throws ComponentInitializationException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        this.action.setSPSessionCreationStrategy((Function)new NullStrategy());
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.prc.getSubcontext(SessionContext.class));
    }

    @Test
    public void testNullSession() throws SessionException, ComponentInitializationException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        IdPSession session = this.sessionManager.createSession("joe");
        ((SessionContext)this.prc.getSubcontext(SessionContext.class, true)).setIdPSession(session);
        this.action.setSPSessionCreationStrategy((Function)new NullStrategy());
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)session.getSPSession("https://sp.example.org"));
    }

    @Test
    public void testBasicSession() throws SessionException, ComponentInitializationException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        IdPSession session = this.sessionManager.createSession("joe");
        ((SessionContext)this.prc.getSubcontext(SessionContext.class, true)).setIdPSession(session);
        long creation = System.currentTimeMillis();
        long expiration = creation + 216000000L;
        this.action.setSPSessionCreationStrategy((Function)new DummyStrategy(creation, expiration));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SPSession spSession = session.getSPSession("https://sp.example.org");
        Assert.assertNotNull((Object)spSession);
        Assert.assertEquals((long)spSession.getCreationInstant(), (long)creation);
        Assert.assertEquals((long)spSession.getExpirationInstant(), (long)expiration);
    }

    private class NullStrategy
    implements Function<ProfileRequestContext, SPSession> {
        private NullStrategy() {
        }

        public SPSession apply(ProfileRequestContext input) {
            return null;
        }
    }

    private class DummyStrategy
    implements Function<ProfileRequestContext, SPSession> {
        private long creationTime;
        private long expirationTime;

        DummyStrategy(long creation, long expiration) {
            this.creationTime = creation;
            this.expirationTime = expiration;
        }

        public SPSession apply(ProfileRequestContext input) {
            return new BasicSPSession("https://sp.example.org", this.creationTime, this.expirationTime);
        }
    }
}

