/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.security.Principal;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.impl.DefaultAuthenticationResultSerializer;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.profile.ActionTestingSupport;
import net.shibboleth.idp.profile.RequestContextBuilder;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.session.criterion.SessionIdCriterion;
import net.shibboleth.idp.session.impl.SessionManagerBaseTestCase;
import net.shibboleth.idp.session.impl.UpdateSessionWithAuthenticationResult;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageSerializer;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class UpdateSessionWithAuthenticationResultTest
extends SessionManagerBaseTestCase {
    private RequestContext src;
    private ProfileRequestContext prc;
    private AuthenticationContext ac;
    private AuthenticationFlowDescriptor flowDescriptor;
    private UpdateSessionWithAuthenticationResult action;

    @BeforeMethod
    public void setUpAction() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, true);
        this.action = new UpdateSessionWithAuthenticationResult();
        this.action.setSessionManager((SessionManager)this.sessionManager);
        this.action.initialize();
    }

    @Override
    protected void adjustProperties() throws ComponentInitializationException {
        DefaultAuthenticationResultSerializer resultSerializer = new DefaultAuthenticationResultSerializer();
        resultSerializer.initialize();
        this.flowDescriptor = new AuthenticationFlowDescriptor();
        this.flowDescriptor.setId("test1");
        this.flowDescriptor.setResultSerializer((StorageSerializer)resultSerializer);
        this.flowDescriptor.initialize();
        this.sessionManager.setAuthenticationFlowDescriptors(Arrays.asList(this.flowDescriptor));
    }

    @Test
    public void testNoResult() {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.prc.getSubcontext(SessionContext.class, false));
    }

    @Test
    public void testNoFlow() throws SessionException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((SubjectContext)this.prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("joe");
        this.ac.setAttemptedFlow(this.flowDescriptor);
        this.ac.setAuthenticationResult(new AuthenticationResult("test2", (Principal)new UsernamePrincipal("joe")));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InputOutputError");
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class, false);
        Assert.assertNotNull((Object)sessionCtx);
        Assert.assertEquals((String)sessionCtx.getIdPSession().getPrincipalName(), (String)"joe");
        Assert.assertEquals((int)sessionCtx.getIdPSession().getAuthenticationResults().size(), (int)0);
        Assert.assertNotNull((Object)((MockHttpServletResponse)HttpServletRequestResponseContext.getResponse()).getCookies()[0]);
    }

    @Test
    public void testNotCacheable() throws SessionException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        this.ac.setAttemptedFlow(this.flowDescriptor);
        this.ac.setAuthenticationResult(new AuthenticationResult("test1", (Principal)new UsernamePrincipal("joe")));
        this.ac.setResultCacheable(false);
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class, true);
        sessionCtx.setIdPSession(this.sessionManager.createSession("joe"));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)sessionCtx.getIdPSession().getAuthenticationResults().size(), (int)0);
    }

    @Test
    public void testNewSession() throws SessionException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((SubjectContext)this.prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("joe");
        this.ac.setAttemptedFlow(this.flowDescriptor);
        this.ac.setAuthenticationResult(new AuthenticationResult("test1", (Principal)new UsernamePrincipal("joe")));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class, false);
        Assert.assertNotNull((Object)sessionCtx);
        Assert.assertEquals((String)sessionCtx.getIdPSession().getPrincipalName(), (String)"joe");
        Assert.assertSame((Object)sessionCtx.getIdPSession().getAuthenticationResult("test1"), (Object)this.ac.getAuthenticationResult());
        Assert.assertNotNull((Object)((MockHttpServletResponse)HttpServletRequestResponseContext.getResponse()).getCookies()[0]);
    }

    @Test
    public void testAddToSession() throws SessionException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        this.ac.setAttemptedFlow(this.flowDescriptor);
        this.ac.setAuthenticationResult(new AuthenticationResult("test1", (Principal)new UsernamePrincipal("joe")));
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class, true);
        sessionCtx.setIdPSession(this.sessionManager.createSession("joe"));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertSame((Object)sessionCtx.getIdPSession().getAuthenticationResult("test1"), (Object)this.ac.getAuthenticationResult());
    }

    @Test
    public void testUpdateSessionNoResult() throws SessionException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        this.ac.setAuthenticationResult(new AuthenticationResult("test1", (Principal)new UsernamePrincipal("joe")));
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class, true);
        sessionCtx.setIdPSession(this.sessionManager.createSession("joe"));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((int)sessionCtx.getIdPSession().getAuthenticationResults().size(), (int)0);
    }

    @Test
    public void testUpdateSession() throws SessionException, ResolverException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        this.ac.setAuthenticationResult(new AuthenticationResult("test1", (Principal)new UsernamePrincipal("joe")));
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class, true);
        sessionCtx.setIdPSession(this.sessionManager.createSession("joe"));
        sessionCtx.getIdPSession().addAuthenticationResult(this.ac.getAuthenticationResult());
        long ts = System.currentTimeMillis() + 300000L;
        this.ac.getAuthenticationResult().setLastActivityInstant(ts);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertSame((Object)sessionCtx.getIdPSession().getAuthenticationResult("test1"), (Object)this.ac.getAuthenticationResult());
        IdPSession session2 = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new SessionIdCriterion(sessionCtx.getIdPSession().getId())}));
        AuthenticationResult result = session2.getAuthenticationResult("test1");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)result.getLastActivityInstant(), (long)ts);
    }
}

