/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import javax.annotation.Nonnull;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.impl.StorageBackedSessionManager;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.CookieManager;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletRequestProxy;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletResponseProxy;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public class SessionManagerBaseTestCase
extends OpenSAMLInitBaseTestCase {
    protected MemoryStorageService storageService;
    protected StorageBackedSessionManager sessionManager;
    protected ThreadLocalHttpServletRequestProxy requestProxy;
    protected ThreadLocalHttpServletResponseProxy responseProxy;

    @BeforeClass
    public void setUp() throws ComponentInitializationException {
        this.requestProxy = new ThreadLocalHttpServletRequestProxy();
        this.responseProxy = new ThreadLocalHttpServletResponseProxy();
        this.storageService = new MemoryStorageService();
        this.storageService.setId("TestStorageService");
        CookieManager cookieManager = new CookieManager();
        cookieManager.setHttpServletRequest((HttpServletRequest)this.requestProxy);
        cookieManager.setHttpServletResponse((HttpServletResponse)this.responseProxy);
        cookieManager.initialize();
        this.sessionManager = new StorageBackedSessionManager();
        this.sessionManager.setSessionTimeout(5000L);
        this.sessionManager.setStorageService((StorageService)this.storageService);
        this.sessionManager.setIDGenerator((IdentifierGenerationStrategy)new SecureRandomIdentifierGenerationStrategy());
        this.sessionManager.setHttpServletRequest((HttpServletRequest)this.requestProxy);
        this.sessionManager.setHttpServletResponse((HttpServletResponse)this.responseProxy);
        this.sessionManager.setCookieManager(cookieManager);
        this.sessionManager.setId("Test Session Manager");
        this.adjustProperties();
        this.storageService.initialize();
        this.sessionManager.initialize();
    }

    protected void adjustProperties() throws ComponentInitializationException {
    }

    @AfterClass
    public void tearDown() {
        this.sessionManager.destroy();
        this.storageService.destroy();
    }

    protected Cookie createSession(@Nonnull @NotEmpty String principalName) throws SessionException {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        this.sessionManager.createSession(principalName);
        Cookie cookie = ((MockHttpServletResponse)HttpServletRequestResponseContext.getResponse()).getCookies()[0];
        HttpServletRequestResponseContext.clearCurrent();
        return cookie;
    }
}

