/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.saml2.profile.config.SAML2ProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.config.SingleLogoutProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.EncryptionParametersResolver;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.EncryptionOptionalCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateEncryptionParameters
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateEncryptionParameters.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, EncryptionContext> encryptionContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(EncryptionContext.class, true), (Function)new ChildContextLookup(RelyingPartyContext.class));
    @Nullable
    private Function<ProfileRequestContext, SAMLPeerEntityContext> peerContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(SAMLPeerEntityContext.class), (Function)new OutboundMessageContextLookup());
    @Nullable
    private String samlProtocol;
    @Nullable
    private QName peerRole;
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<EncryptionConfiguration>> configurationLookupStrategy;
    @NonnullAfterInit
    private EncryptionParametersResolver encParamsresolver;
    @Nullable
    @NonnullElements
    private List<EncryptionConfiguration> encryptionConfigurations;
    private boolean encryptionOptional;
    private boolean encryptAssertions;
    private boolean encryptIdentifiers;
    private boolean encryptAttributes;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setEncryptionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EncryptionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encryptionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionContext lookup strategy cannot be null");
    }

    public void setProtocol(@Nullable String protocol) {
        this.samlProtocol = StringSupport.trimOrNull((String)protocol);
    }

    public void setRole(@Nullable QName role) {
        this.peerRole = role;
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, List<EncryptionConfiguration>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionConfiguration lookup strategy cannot be null");
    }

    public void setPeerContextLookupStrategy(@Nullable Function<ProfileRequestContext, SAMLPeerEntityContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.peerContextLookupStrategy = strategy;
    }

    public void setEncryptionParametersResolver(@Nonnull EncryptionParametersResolver newResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encParamsresolver = (EncryptionParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"EncryptionParametersResolver cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.encParamsresolver == null) {
            throw new ComponentInitializationException("EncryptionParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            this.configurationLookupStrategy = new Function<ProfileRequestContext, List<EncryptionConfiguration>>(){

                public List<EncryptionConfiguration> apply(ProfileRequestContext input) {
                    return Collections.singletonList(SecurityConfigurationSupport.getGlobalEncryptionConfiguration());
                }
            };
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RelyingPartyContext rpContext = (RelyingPartyContext)this.relyingPartyContextLookupStrategy.apply((Object)profileRequestContext);
        if (rpContext == null) {
            this.log.debug("{} Unable to locate RelyingPartyContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        if (rpContext.getProfileConfig() == null) {
            this.log.debug("{} Unable to locate RelyingPartyContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        if (!(rpContext.getProfileConfig() instanceof SAML2ProfileConfiguration)) {
            this.log.debug("{} Not a SAML 2 profile configuration, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        Object msg = null;
        if (profileRequestContext.getInboundMessageContext() != null) {
            msg = profileRequestContext.getInboundMessageContext().getMessage();
        }
        if (msg instanceof AuthnRequest) {
            String requestedFormat;
            AuthnRequest request = (AuthnRequest)msg;
            if (request.getNameIDPolicy() != null && (requestedFormat = request.getNameIDPolicy().getFormat()) != null && "urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted".equals(requestedFormat)) {
                this.log.debug("{} Request asked for encrypted identifier, disregarding installed predicate");
                this.encryptIdentifiers = true;
            }
        } else if (msg != null && rpContext.getProfileConfig() instanceof SingleLogoutProfileConfiguration) {
            this.log.debug("{} Inbound logout message, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        SAML2ProfileConfiguration profileConfiguration = (SAML2ProfileConfiguration)rpContext.getProfileConfig();
        if (!this.encryptIdentifiers) {
            this.encryptIdentifiers = profileConfiguration.getEncryptNameIDs().apply((Object)profileRequestContext);
            this.encryptionOptional = profileConfiguration.isEncryptionOptional();
        }
        this.encryptAssertions = profileConfiguration.getEncryptAssertions().apply((Object)profileRequestContext);
        this.encryptAttributes = profileConfiguration.getEncryptAttributes().apply((Object)profileRequestContext);
        if (!(this.encryptAssertions || this.encryptIdentifiers || this.encryptAttributes)) {
            this.log.debug("{} No encryption requested, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.encryptionConfigurations = (List)this.configurationLookupStrategy.apply((Object)profileRequestContext);
        this.log.debug("{} Encryption for assertions ({}), identifiers ({}), attributes({})", new Object[]{this.getLogPrefix(), this.encryptAssertions, this.encryptIdentifiers, this.encryptAttributes});
        return super.doPreExecute(profileRequestContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Resolving EncryptionParameters for request", (Object)this.getLogPrefix());
        EncryptionContext encryptCtx = (EncryptionContext)this.encryptionContextLookupStrategy.apply((Object)profileRequestContext);
        if (encryptCtx == null) {
            this.log.debug("{} No EncryptionContext returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        try {
            if (this.encryptionConfigurations == null || this.encryptionConfigurations.isEmpty()) {
                throw new ResolverException("No EncryptionConfigurations returned by lookup strategy");
            }
            EncryptionParameters params = (EncryptionParameters)this.encParamsresolver.resolveSingle((Object)this.buildCriteriaSet(profileRequestContext));
            this.log.debug("{} {} EncryptionParameters", (Object)this.getLogPrefix(), (Object)(params != null ? "Resolved" : "Failed to resolve"));
            if (params != null) {
                if (this.encryptAssertions) {
                    encryptCtx.setAssertionEncryptionParameters(params);
                }
                if (this.encryptIdentifiers) {
                    encryptCtx.setIdentifierEncryptionParameters(params);
                }
                if (this.encryptAttributes) {
                    encryptCtx.setAttributeEncryptionParameters(params);
                }
            } else if (this.encryptionOptional) {
                this.log.debug("{} Resolver returned no EncryptionParameters", (Object)this.getLogPrefix());
                this.log.debug("{} Encryption is optional, ignoring inability to encrypt", (Object)this.getLogPrefix());
            } else {
                this.log.warn("{} Resolver returned no EncryptionParameters", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            }
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving EncryptionParameters", (Object)this.getLogPrefix(), (Object)e);
            if (this.encryptionOptional) {
                this.log.debug("{} Encryption is optional, ignoring inability to encrypt", (Object)this.getLogPrefix());
            }
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
        }
    }

    @Nonnull
    private CriteriaSet buildCriteriaSet(@Nonnull ProfileRequestContext profileRequestContext) {
        SAMLPeerEntityContext peerCtx;
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new EncryptionConfigurationCriterion(this.encryptionConfigurations)});
        criteria.add((Object)new EncryptionOptionalCriterion(this.encryptionOptional));
        if (this.peerContextLookupStrategy != null && (peerCtx = (SAMLPeerEntityContext)this.peerContextLookupStrategy.apply((Object)profileRequestContext)) != null) {
            SAMLMetadataContext metadataCtx;
            if (peerCtx.getEntityId() != null) {
                this.log.debug("{} Adding entityID to resolution criteria", (Object)this.getLogPrefix());
                criteria.add((Object)new EntityIdCriterion(peerCtx.getEntityId()));
                if (this.samlProtocol != null) {
                    criteria.add((Object)new ProtocolCriterion(this.samlProtocol));
                }
                if (this.peerRole != null) {
                    criteria.add((Object)new EntityRoleCriterion(this.peerRole));
                }
            }
            if ((metadataCtx = (SAMLMetadataContext)peerCtx.getSubcontext(SAMLMetadataContext.class)) != null && metadataCtx.getRoleDescriptor() != null) {
                this.log.debug("{} Adding role metadata to resolution criteria", (Object)this.getLogPrefix());
                criteria.add((Object)new RoleDescriptorCriterion(metadataCtx.getRoleDescriptor()));
            }
        }
        return criteria;
    }
}

